/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.GrControlFlowPolicy;

public class GrResolverPolicy
implements GrControlFlowPolicy {
    private static final GrResolverPolicy INSTANCE = new GrResolverPolicy();

    @Override
    public boolean isReferenceAccepted(@NotNull GrReferenceExpression ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/GrResolverPolicy", "isReferenceAccepted"));
        }
        return !ref.isQualified();
    }

    @Override
    public boolean isVariableInitialized(@NotNull GrVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/GrResolverPolicy", "isVariableInitialized"));
        }
        return variable.getInitializerGroovy() != null || GrResolverPolicy.hasTupleInitializer(variable) || variable instanceof GrParameter;
    }

    private static boolean hasTupleInitializer(@NotNull GrVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/GrResolverPolicy", "hasTupleInitializer"));
        }
        PsiElement parent = variable.getParent();
        return parent instanceof GrVariableDeclaration && ((GrVariableDeclaration)parent).getTupleInitializer() != null;
    }

    public static GrResolverPolicy getInstance() {
        return INSTANCE;
    }
}

