/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.util;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;

public abstract class ParserUtils {
    public static boolean getToken(PsiBuilder builder, IElementType elem, String errorMsg) {
        if (elem.equals(builder.getTokenType())) {
            builder.advanceLexer();
            return true;
        }
        if (errorMsg != null) {
            builder.error(errorMsg);
        }
        return false;
    }

    public static boolean getToken(PsiBuilder builder, IElementType elem) {
        if (elem.equals(builder.getTokenType())) {
            builder.advanceLexer();
            return true;
        }
        return false;
    }

    public static boolean getToken(PsiBuilder builder, TokenSet tokenSet) {
        if (tokenSet.contains(builder.getTokenType())) {
            return ParserUtils.getToken(builder, builder.getTokenType(), null);
        }
        return false;
    }

    public static boolean getToken(PsiBuilder builder, TokenSet tokenSet, String msg) {
        if (tokenSet.contains(builder.getTokenType())) {
            return ParserUtils.getToken(builder, builder.getTokenType(), msg);
        }
        return false;
    }

    public static boolean lookAhead(PsiBuilder builder, IElementType[] elems) {
        int i;
        if (elems[0] != builder.getTokenType()) {
            return false;
        }
        if (elems.length == 1) {
            return true;
        }
        PsiBuilder.Marker rb = builder.mark();
        builder.advanceLexer();
        for (i = 1; !builder.eof() && i < elems.length && elems[i] == builder.getTokenType(); ++i) {
            builder.advanceLexer();
        }
        rb.rollbackTo();
        return i == elems.length;
    }

    public static boolean lookAhead(PsiBuilder builder, IElementType element1) {
        return element1 == builder.getTokenType();
    }

    public static boolean lookAhead(PsiBuilder builder, IElementType element1, IElementType element2) {
        if (element1 != builder.getTokenType()) {
            return false;
        }
        PsiBuilder.Marker rb = builder.mark();
        builder.advanceLexer();
        boolean res = !builder.eof() && element2 == builder.getTokenType();
        rb.rollbackTo();
        return res;
    }

    public static boolean lookAhead(PsiBuilder builder, IElementType element1, IElementType element2, IElementType element3) {
        if (element1 != builder.getTokenType()) {
            return false;
        }
        PsiBuilder.Marker rb = builder.mark();
        boolean res = false;
        builder.advanceLexer();
        if (!builder.eof() && element2 == builder.getTokenType()) {
            builder.advanceLexer();
            res = !builder.eof() && element3 == builder.getTokenType();
        }
        rb.rollbackTo();
        return res;
    }

    public static boolean lookAhead(PsiBuilder builder, IElementType element1, IElementType element2, IElementType element3, IElementType element4) {
        if (element1 != builder.getTokenType()) {
            return false;
        }
        PsiBuilder.Marker rb = builder.mark();
        boolean res = false;
        builder.advanceLexer();
        if (!builder.eof() && element2 == builder.getTokenType()) {
            builder.advanceLexer();
            if (!builder.eof() && element3 == builder.getTokenType()) {
                builder.advanceLexer();
                res = !builder.eof() && element4 == builder.getTokenType();
            }
        }
        rb.rollbackTo();
        return res;
    }

    public static IElementType eatElement(PsiBuilder builder, IElementType elem) {
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        marker.done(elem);
        return elem;
    }

    public static void wrapError(PsiBuilder builder, String msg) {
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        marker.error(msg);
    }

    public static boolean skipCountingBraces(PsiBuilder builder, TokenSet until) {
        int braceLevel = 0;
        while (!builder.eof()) {
            IElementType type = builder.getTokenType();
            if (braceLevel == 0 && until.contains(type)) {
                return true;
            }
            if (GroovyTokenTypes.mLCURLY == type) {
                ++braceLevel;
            } else if (GroovyTokenTypes.mRCURLY == type) {
                --braceLevel;
            }
            builder.advanceLexer();
        }
        return false;
    }
}

