/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.typeDefinitions;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.Separators;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.typeDefinitions.ClassType;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.typeDefinitions.ReferenceElement;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.typeDefinitions.members.EnumConstant;
import org.jetbrains.plugins.groovy.lang.parser.parsing.types.TypeParameters;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class TypeDefinition
implements GroovyElementTypes {
    public static IElementType parseAfterModifiers(PsiBuilder builder, GroovyParser parser) {
        if (builder.getTokenType() == kCLASS) {
            builder.advanceLexer();
            if (TypeDefinition.parseAfterKeyword(builder, parser, ClassType.CLASS)) {
                return CLASS_DEFINITION;
            }
        }
        if (builder.getTokenType() == kINTERFACE) {
            builder.advanceLexer();
            if (TypeDefinition.parseAfterKeyword(builder, parser, ClassType.INTERFACE)) {
                return INTERFACE_DEFINITION;
            }
        }
        if (builder.getTokenType() == kENUM) {
            builder.advanceLexer();
            if (TypeDefinition.parseAfterKeyword(builder, parser, ClassType.ENUM)) {
                return ENUM_DEFINITION;
            }
        }
        if (builder.getTokenType() == mAT) {
            builder.advanceLexer();
            if (builder.getTokenType() == kINTERFACE) {
                builder.advanceLexer();
                if (TypeDefinition.parseAfterKeyword(builder, parser, ClassType.ANNOTATION)) {
                    return ANNOTATION_DEFINITION;
                }
            }
        }
        return WRONGWAY;
    }

    private static boolean parseAfterKeyword(PsiBuilder builder, GroovyParser parser, ClassType type) {
        if (builder.getTokenType() != mIDENT) {
            builder.error(GroovyBundle.message("identifier.expected", new Object[0]));
            return false;
        }
        String name = builder.getTokenText();
        assert (name != null);
        builder.advanceLexer();
        ParserUtils.getToken(builder, mNLS);
        TypeParameters.parse(builder);
        ParserUtils.getToken(builder, mNLS);
        ReferenceElement.parseReferenceList(builder, kEXTENDS, EXTENDS_CLAUSE, type);
        ParserUtils.getToken(builder, mNLS);
        ReferenceElement.parseReferenceList(builder, kIMPLEMENTS, IMPLEMENTS_CLAUSE, type);
        ParserUtils.getToken(builder, mNLS);
        if (builder.getTokenType() == mLCURLY) {
            if (type == ClassType.ENUM) {
                TypeDefinition.parseEnumBody(builder, name, parser);
            } else {
                TypeDefinition.parseBody(builder, name, parser, type == ClassType.ANNOTATION);
            }
        } else {
            builder.error(GroovyBundle.message("lcurly.expected", new Object[0]));
        }
        return true;
    }

    public static IElementType parseBody(@NotNull PsiBuilder builder, @Nullable String className, @NotNull GroovyParser parser, boolean isInAnnotation) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/TypeDefinition", "parseBody"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/TypeDefinition", "parseBody"));
        }
        PsiBuilder.Marker cbMarker = builder.mark();
        if (!ParserUtils.getToken(builder, mLCURLY)) {
            builder.error(GroovyBundle.message("lcurly.expected", new Object[0]));
            cbMarker.rollbackTo();
            return WRONGWAY;
        }
        TypeDefinition.parseMembers(builder, className, parser, isInAnnotation);
        ParserUtils.getToken(builder, mRCURLY, GroovyBundle.message("rcurly.expected", new Object[0]));
        cbMarker.done((IElementType)CLASS_BODY);
        return CLASS_BODY;
    }

    private static void parseMembers(@NotNull PsiBuilder builder, @Nullable String className, @NotNull GroovyParser parser, boolean isInAnnotation) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/TypeDefinition", "parseMembers"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/TypeDefinition", "parseMembers"));
        }
        Separators.parse(builder);
        while (!builder.eof() && builder.getTokenType() != mRCURLY) {
            if (!parser.parseDeclaration(builder, true, isInAnnotation, className)) {
                builder.advanceLexer();
                builder.error(GroovyBundle.message("separator.or.rcurly.expected", new Object[0]));
            }
            if (builder.getTokenType() == mRCURLY) break;
            if (Separators.parse(builder)) continue;
            builder.error(GroovyBundle.message("separator.or.rcurly.expected", new Object[0]));
        }
    }

    private static IElementType parseEnumBody(@NotNull PsiBuilder builder, @NotNull String enumName, @NotNull GroovyParser parser) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/TypeDefinition", "parseEnumBody"));
        }
        if (enumName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/TypeDefinition", "parseEnumBody"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/TypeDefinition", "parseEnumBody"));
        }
        PsiBuilder.Marker ebMarker = builder.mark();
        if (!ParserUtils.getToken(builder, mLCURLY)) {
            ebMarker.rollbackTo();
            return WRONGWAY;
        }
        ParserUtils.getToken(builder, mNLS);
        EnumConstant.parseConstantList(builder, parser);
        TypeDefinition.parseMembers(builder, enumName, parser, false);
        ParserUtils.getToken(builder, mRCURLY, GroovyBundle.message("rcurly.expected", new Object[0]));
        ebMarker.done((IElementType)ENUM_BODY);
        return ENUM_BODY;
    }
}

