/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.primary;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyElementType;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.blocks.OpenOrClosableBlock;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.AssignmentExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.arguments.ArgumentList;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.primary.CompoundStringExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.primary.ListOrMapConstructorExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.typeDefinitions.ReferenceElement;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.typeDefinitions.TypeDefinition;
import org.jetbrains.plugins.groovy.lang.parser.parsing.types.TypeArguments;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class PrimaryExpression
implements GroovyElementTypes {
    public static IElementType parsePrimaryExpression(PsiBuilder builder, GroovyParser parser) {
        return PrimaryExpression.parsePrimaryExpression(builder, parser, false);
    }

    public static IElementType parsePrimaryExpression(PsiBuilder builder, GroovyParser parser, boolean literalsAsRefExprs) {
        IElementType tokenType = builder.getTokenType();
        if (TokenSets.BUILT_IN_TYPES.contains(tokenType)) {
            ParserUtils.eatElement(builder, BUILT_IN_TYPE_EXPRESSION);
            return BUILT_IN_TYPE_EXPRESSION;
        }
        if (kNEW == tokenType) {
            PsiBuilder.Marker marker = builder.mark();
            GroovyElementType type = PrimaryExpression.newExprParse(builder, parser);
            marker.done((IElementType)type);
            return type;
        }
        if (mIDENT == tokenType || kSUPER == tokenType || kTHIS == tokenType) {
            ParserUtils.eatElement(builder, REFERENCE_EXPRESSION);
            return REFERENCE_EXPRESSION;
        }
        if (mGSTRING_BEGIN == tokenType) {
            boolean result = CompoundStringExpression.parse(builder, parser, false, mGSTRING_BEGIN, mGSTRING_CONTENT, mGSTRING_END, null, GSTRING, GroovyBundle.message("string.end.expected", new Object[0]));
            return result ? GSTRING : LITERAL;
        }
        if (mREGEX_BEGIN == tokenType) {
            CompoundStringExpression.parse(builder, parser, false, mREGEX_BEGIN, mREGEX_CONTENT, mREGEX_END, mREGEX_LITERAL, REGEX, GroovyBundle.message("regex.end.expected", new Object[0]));
            return REGEX;
        }
        if (mDOLLAR_SLASH_REGEX_BEGIN == tokenType) {
            CompoundStringExpression.parse(builder, parser, false, mDOLLAR_SLASH_REGEX_BEGIN, mDOLLAR_SLASH_REGEX_CONTENT, mDOLLAR_SLASH_REGEX_END, mDOLLAR_SLASH_REGEX_LITERAL, REGEX, GroovyBundle.message("dollar.slash.end.expected", new Object[0]));
            return REGEX;
        }
        if (mLBRACK == tokenType) {
            return ListOrMapConstructorExpression.parse(builder, parser);
        }
        if (mLPAREN == tokenType) {
            return PrimaryExpression.parenthesizedExprParse(builder, parser);
        }
        if (mLCURLY == tokenType) {
            return OpenOrClosableBlock.parseClosableBlock(builder, parser);
        }
        if (tokenType == mSTRING_LITERAL || tokenType == mGSTRING_LITERAL) {
            return ParserUtils.eatElement(builder, literalsAsRefExprs ? REFERENCE_EXPRESSION : LITERAL);
        }
        if (TokenSets.CONSTANTS.contains(tokenType)) {
            return ParserUtils.eatElement(builder, LITERAL);
        }
        return WRONGWAY;
    }

    public static GroovyElementType parenthesizedExprParse(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker marker = builder.mark();
        ParserUtils.getToken(builder, mLPAREN);
        if (!AssignmentExpression.parse(builder, parser)) {
            builder.error(GroovyBundle.message("expression.expected", new Object[0]));
        }
        ParserUtils.getToken(builder, mNLS);
        ParserUtils.getToken(builder, mRPAREN, GroovyBundle.message("rparen.expected", new Object[0]));
        marker.done((IElementType)PARENTHESIZED_EXPRESSION);
        return PARENTHESIZED_EXPRESSION;
    }

    public static GroovyElementType newExprParse(PsiBuilder builder, GroovyParser parser) {
        String name;
        ParserUtils.getToken(builder, kNEW);
        ParserUtils.getToken(builder, mNLS);
        PsiBuilder.Marker rb = builder.mark();
        TypeArguments.parseTypeArguments(builder, false);
        if (!TokenSets.BUILT_IN_TYPES.contains(builder.getTokenType()) && mIDENT != builder.getTokenType()) {
            rb.rollbackTo();
        } else {
            rb.drop();
        }
        PsiBuilder.Marker anonymousMarker = builder.mark();
        if (TokenSets.BUILT_IN_TYPES.contains(builder.getTokenType())) {
            ParserUtils.eatElement(builder, BUILT_IN_TYPE);
            name = null;
        } else if (TokenSets.CODE_REFERENCE_ELEMENT_NAME_TOKENS.contains(builder.getTokenType())) {
            name = builder.getTokenText();
            ReferenceElement.parse(builder, false, true, false, true, true);
        } else {
            builder.error(GroovyBundle.message("type.specification.expected", new Object[0]));
            anonymousMarker.drop();
            return NEW_EXPRESSION;
        }
        if (builder.getTokenType() == mLPAREN || ParserUtils.lookAhead(builder, mNLS, mLPAREN)) {
            ParserUtils.getToken(builder, mNLS);
            PrimaryExpression.methodCallArgsParse(builder, parser);
            if (builder.getTokenType() == mLCURLY || ParserUtils.lookAhead(builder, mNLS, mLCURLY)) {
                ParserUtils.getToken(builder, mNLS);
                TypeDefinition.parseBody(builder, name, parser, false);
                anonymousMarker.done((IElementType)ANONYMOUS_CLASS_DEFINITION);
                return NEW_EXPRESSION;
            }
        } else if (builder.getTokenType() == mLBRACK) {
            PsiBuilder.Marker forArray = builder.mark();
            ParserUtils.getToken(builder, mNLS);
            ParserUtils.getToken(builder, mLBRACK);
            if (!AssignmentExpression.parse(builder, parser)) {
                builder.error(GroovyBundle.message("expression.expected", new Object[0]));
            }
            ParserUtils.getToken(builder, mNLS);
            ParserUtils.getToken(builder, mRBRACK, GroovyBundle.message("rbrack.expected", new Object[0]));
            while (ParserUtils.getToken(builder, mLBRACK)) {
                ParserUtils.getToken(builder, mNLS);
                AssignmentExpression.parse(builder, parser);
                ParserUtils.getToken(builder, mNLS);
                ParserUtils.getToken(builder, mRBRACK, GroovyBundle.message("rbrack.expected", new Object[0]));
            }
            forArray.done((IElementType)ARRAY_DECLARATOR);
        } else {
            builder.error(GroovyBundle.message("lparen.expected", new Object[0]));
        }
        anonymousMarker.drop();
        return NEW_EXPRESSION;
    }

    public static boolean methodCallArgsParse(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker marker = builder.mark();
        if (ParserUtils.getToken(builder, mLPAREN, GroovyBundle.message("lparen.expected", new Object[0]))) {
            ParserUtils.getToken(builder, mNLS);
            ArgumentList.parseArgumentList(builder, mRPAREN, parser);
            ParserUtils.getToken(builder, mNLS);
            ParserUtils.getToken(builder, mRPAREN, GroovyBundle.message("rparen.expected", new Object[0]));
        }
        marker.done((IElementType)ARGUMENTS);
        return true;
    }
}

