/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.declaration;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.ThrowClause;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.annotations.AnnotationArguments;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.parameters.ParameterList;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.TupleParse;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.blocks.OpenOrClosableBlock;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.constructor.ConstructorBody;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.AssignmentExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class VariableDefinitions
implements GroovyElementTypes {
    public static IElementType parseDefinitions(@NotNull PsiBuilder builder, boolean isInClass, boolean isInAnnotation, @Nullable String typeDefinitionName, boolean hasModifiers, boolean canBeTuple, @NotNull GroovyParser parser) {
        boolean isStringName;
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/declaration/VariableDefinitions", "parseDefinitions"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/declaration/VariableDefinitions", "parseDefinitions"));
        }
        boolean isLParenth = builder.getTokenType() == mLPAREN;
        boolean bl = isStringName = builder.getTokenType() == mSTRING_LITERAL || builder.getTokenType() == mGSTRING_LITERAL;
        if (builder.getTokenType() != mIDENT && !isStringName && !isLParenth) {
            builder.error(GroovyBundle.message("indentifier.or.string.or.left.parenth.literal.expected", new Object[0]));
            return WRONGWAY;
        }
        if (isLParenth && !canBeTuple) {
            builder.error(GroovyBundle.message("indentifier.or.string.or.left.parenth.literal.expected", new Object[0]));
            return WRONGWAY;
        }
        if (isInAnnotation && isStringName) {
            builder.error(GroovyBundle.message("string.name.unexpected", new Object[0]));
        }
        if (!isLParenth) {
            PsiBuilder.Marker varMarker = builder.mark();
            boolean isConstructor = isInClass && !isInAnnotation && typeDefinitionName != null && builder.getTokenType() == mIDENT && typeDefinitionName.equals(builder.getTokenText());
            builder.advanceLexer();
            if (mLPAREN != builder.getTokenType()) {
                varMarker.rollbackTo();
            } else {
                varMarker.drop();
                return VariableDefinitions.parseMethod(builder, isInAnnotation, hasModifiers, parser, isConstructor);
            }
        }
        return VariableDefinitions.parseVar(builder, isInClass, hasModifiers, parser, isLParenth);
    }

    private static IElementType parseVar(PsiBuilder builder, boolean isInClass, boolean hasModifiers, GroovyParser parser, boolean LParenth) {
        PsiBuilder.Marker varAssMarker = builder.mark();
        IElementType declarator = VariableDefinitions.parseDeclarator(builder, LParenth);
        if (declarator != WRONGWAY) {
            boolean wasAssignment = VariableDefinitions.parseAssignment(builder, parser);
            if (declarator == TUPLE_DECLARATION) {
                varAssMarker.drop();
                if (!wasAssignment && !hasModifiers) {
                    builder.error(GroovyBundle.message("assignment.expected", new Object[0]));
                    return WRONGWAY;
                }
            } else if (isInClass) {
                varAssMarker.done((IElementType)FIELD);
            } else {
                varAssMarker.done((IElementType)VARIABLE);
            }
            while (ParserUtils.getToken(builder, mCOMMA)) {
                ParserUtils.getToken(builder, mNLS);
                if (!((Object)((Object)WRONGWAY)).equals(VariableDefinitions.parseVariableOrField(builder, isInClass, parser)) || declarator != mIDENT) continue;
                return VARIABLE_DEFINITION_ERROR;
            }
            if (isInClass && declarator == TUPLE_DECLARATION) {
                builder.error(GroovyBundle.message("tuple.cant.be.placed.in.class", new Object[0]));
            }
            return VARIABLE_DEFINITION;
        }
        varAssMarker.drop();
        builder.error(GroovyBundle.message("identifier.expected", new Object[0]));
        return WRONGWAY;
    }

    private static IElementType parseMethod(PsiBuilder builder, boolean isAnnotationMember, boolean hasModifiers, GroovyParser parser, boolean constructor) {
        if (!hasModifiers && !constructor) {
            builder.error(GroovyBundle.message("method.definition.without.modifier", new Object[0]));
            return WRONGWAY;
        }
        builder.advanceLexer();
        ParameterList.parse(builder, mRPAREN, parser);
        ParserUtils.getToken(builder, mNLS);
        if (!ParserUtils.getToken(builder, mRPAREN)) {
            builder.error(GroovyBundle.message("rparen.expected", new Object[0]));
            ThrowClause.parse(builder);
            return VariableDefinitions.methodType(isAnnotationMember, constructor);
        }
        if (isAnnotationMember && builder.getTokenType() == kDEFAULT) {
            ParserUtils.getToken(builder, kDEFAULT);
            ParserUtils.getToken(builder, mNLS);
            if (!AnnotationArguments.parseAnnotationMemberValueInitializer(builder, parser)) {
                builder.error(GroovyBundle.message("annotation.initializer.expected", new Object[0]));
            }
        }
        if (ParserUtils.lookAhead(builder, mNLS, kTHROWS) || ParserUtils.lookAhead(builder, mNLS, mLCURLY)) {
            ParserUtils.getToken(builder, mNLS);
        }
        if (isAnnotationMember && builder.getTokenType() == kTHROWS) {
            builder.error(GroovyBundle.message("throws.clause.is.not.allowed.in.at.interface", new Object[0]));
        }
        ThrowClause.parse(builder);
        if (builder.getTokenType() == mLCURLY || ParserUtils.lookAhead(builder, mNLS, mLCURLY)) {
            ParserUtils.getToken(builder, mNLS);
            if (isAnnotationMember) {
                builder.error(GroovyBundle.message("separator.or.rcurly.expected", new Object[0]));
            }
            if (constructor) {
                ConstructorBody.parseConstructorBody(builder, parser);
            } else {
                OpenOrClosableBlock.parseOpenBlock(builder, parser);
            }
        }
        return VariableDefinitions.methodType(isAnnotationMember, constructor);
    }

    private static IElementType methodType(boolean isAnnotationMember, boolean isConstructor) {
        return isAnnotationMember ? ANNOTATION_METHOD : (isConstructor ? CONSTRUCTOR_DEFINITION : METHOD_DEFINITION);
    }

    private static IElementType parseVariableOrField(PsiBuilder builder, boolean isInClass, GroovyParser parser) {
        PsiBuilder.Marker varAssMarker = builder.mark();
        if (ParserUtils.getToken(builder, mIDENT)) {
            VariableDefinitions.parseAssignment(builder, parser);
            if (isInClass) {
                varAssMarker.done((IElementType)FIELD);
                return FIELD;
            }
            varAssMarker.done((IElementType)VARIABLE);
            return VARIABLE;
        }
        varAssMarker.drop();
        builder.error("Identifier expected");
        return WRONGWAY;
    }

    private static IElementType parseDeclarator(PsiBuilder builder, boolean isTuple) {
        if (isTuple && builder.getTokenType() == mLPAREN && TupleParse.parseTupleForVariableDeclaration(builder)) {
            return TUPLE_DECLARATION;
        }
        if (!isTuple && ParserUtils.getToken(builder, mIDENT)) {
            return mIDENT;
        }
        return WRONGWAY;
    }

    private static boolean parseAssignment(PsiBuilder builder, GroovyParser parser) {
        if (ParserUtils.getToken(builder, mASSIGN)) {
            PsiBuilder.Marker marker = builder.mark();
            ParserUtils.getToken(builder, mNLS);
            if (!AssignmentExpression.parse(builder, parser, true)) {
                marker.rollbackTo();
                builder.error(GroovyBundle.message("expression.expected", new Object[0]));
                return false;
            }
            marker.drop();
            return true;
        }
        return false;
    }
}

