/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.declaration;

import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.modifiers.Modifiers;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.declaration.VariableDefinitions;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.typeDefinitions.ReferenceElement;
import org.jetbrains.plugins.groovy.lang.parser.parsing.types.TypeParameters;
import org.jetbrains.plugins.groovy.lang.parser.parsing.types.TypeSpec;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class Declaration
implements GroovyElementTypes {
    public static boolean parse(@NotNull PsiBuilder builder, boolean isInClass, boolean isInAnnotation, @Nullable String typeDefinitionName, @NotNull GroovyParser parser) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/declaration/Declaration", "parse"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/declaration/Declaration", "parse"));
        }
        PsiBuilder.Marker declMarker = builder.mark();
        boolean modifiersParsed = Modifiers.parse(builder, parser);
        boolean methodStart = mLT == builder.getTokenType();
        IElementType type = Declaration.parseAfterModifiers(builder, isInClass, isInAnnotation, typeDefinitionName, parser, modifiersParsed);
        if (type == WRONGWAY) {
            if (modifiersParsed && methodStart) {
                declMarker.error(GroovyBundle.message("method.definitions.expected", new Object[0]));
                return false;
            }
            declMarker.rollbackTo();
            if (modifiersParsed) {
                builder.error(GroovyBundle.message("variable.definitions.expected", new Object[0]));
            }
            return false;
        }
        if (type != null) {
            declMarker.done(type);
        } else {
            declMarker.drop();
        }
        return true;
    }

    @Nullable
    public static IElementType parseAfterModifiers(@NotNull PsiBuilder builder, boolean isInClass, boolean isInAnnotation, @Nullable String typeDefinitionName, @NotNull GroovyParser parser, boolean modifiersParsed) {
        boolean expressionPossible;
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/declaration/Declaration", "parseAfterModifiers"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/declaration/Declaration", "parseAfterModifiers"));
        }
        boolean bl = expressionPossible = !isInAnnotation && !isInClass;
        if (modifiersParsed && builder.getTokenType() == mLT) {
            return Declaration.parseDeclarationWithGenerics(builder, isInClass, isInAnnotation, typeDefinitionName, parser, modifiersParsed, expressionPossible);
        }
        if (modifiersParsed) {
            return Declaration.parseDeclarationWithoutGenerics(builder, isInClass, isInAnnotation, typeDefinitionName, parser, modifiersParsed, expressionPossible);
        }
        if (typeDefinitionName != null && ParserUtils.lookAhead(builder, mIDENT, mLPAREN) && typeDefinitionName.equals(builder.getTokenText())) {
            return VariableDefinitions.parseDefinitions(builder, isInClass, isInAnnotation, typeDefinitionName, modifiersParsed, false, parser);
        }
        return Declaration.parsePossibleCallExpression(builder, isInClass, isInAnnotation, typeDefinitionName, parser, expressionPossible);
    }

    private static IElementType parsePossibleCallExpression(@NotNull PsiBuilder builder, boolean isInClass, boolean isInAnnotation, @Nullable String typeDefinitionName, @NotNull GroovyParser parser, boolean expressionPossible) {
        IElementType varDef;
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/declaration/Declaration", "parsePossibleCallExpression"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/declaration/Declaration", "parsePossibleCallExpression"));
        }
        if (Declaration.isCall(builder)) {
            return WRONGWAY;
        }
        boolean typeParsed = false;
        if (!ParserUtils.lookAhead(builder, mIDENT, mLPAREN)) {
            boolean bl = typeParsed = TypeSpec.parse(builder, true, expressionPossible) != ReferenceElement.ReferenceElementResult.FAIL;
            if (!typeParsed) {
                return WRONGWAY;
            }
        }
        if ((varDef = VariableDefinitions.parseDefinitions(builder, isInClass, isInAnnotation, typeDefinitionName, typeParsed, false, parser)) != WRONGWAY) {
            return varDef;
        }
        if (isInClass && typeParsed) {
            return null;
        }
        return WRONGWAY;
    }

    private static boolean isCall(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/declaration/Declaration", "isCall"));
        }
        if (builder.eof()) {
            return false;
        }
        if (TokenSets.BUILT_IN_TYPES.contains(builder.getTokenType())) {
            return false;
        }
        String text = builder.getTokenText();
        if (StringUtil.isEmpty((String)text)) {
            return false;
        }
        assert (text != null);
        char firstChar = text.charAt(0);
        return !(!Character.isLowerCase(firstChar) && Character.isLetter(firstChar) || !ParserUtils.lookAhead(builder, mIDENT, mIDENT) && !ParserUtils.lookAhead(builder, mIDENT, mLPAREN));
    }

    private static IElementType parseDeclarationWithoutGenerics(@NotNull PsiBuilder builder, boolean isInClass, boolean isInAnnotation, @Nullable String typeDefinitionName, @NotNull GroovyParser parser, boolean modifiersParsed, boolean expressionPossible) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/declaration/Declaration", "parseDeclarationWithoutGenerics"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/declaration/Declaration", "parseDeclarationWithoutGenerics"));
        }
        PsiBuilder.Marker checkMarker = builder.mark();
        ReferenceElement.ReferenceElementResult typeResult = TypeSpec.parse(builder, false, expressionPossible);
        if (typeResult == ReferenceElement.ReferenceElementResult.FAIL) {
            checkMarker.rollbackTo();
            if (isInAnnotation) {
                builder.error(GroovyBundle.message("type.expected", new Object[0]));
            }
            return VariableDefinitions.parseDefinitions(builder, isInClass, isInAnnotation, typeDefinitionName, modifiersParsed, true, parser);
        }
        IElementType varDeclarationTop = VariableDefinitions.parseDefinitions(builder, isInClass, isInAnnotation, typeDefinitionName, modifiersParsed, false, parser);
        if (varDeclarationTop == WRONGWAY) {
            if (typeResult == ReferenceElement.ReferenceElementResult.REF_WITH_TYPE_PARAMS) {
                checkMarker.drop();
                return VARIABLE_DEFINITION_ERROR;
            }
            checkMarker.rollbackTo();
            if (isInAnnotation) {
                builder.error(GroovyBundle.message("type.expected", new Object[0]));
            }
            return VariableDefinitions.parseDefinitions(builder, isInClass, isInAnnotation, typeDefinitionName, modifiersParsed, false, parser);
        }
        checkMarker.drop();
        return varDeclarationTop;
    }

    private static IElementType parseDeclarationWithGenerics(@NotNull PsiBuilder builder, boolean isInClass, boolean isInAnnotation, @Nullable String typeDefinitionName, @NotNull GroovyParser parser, boolean modifiersParsed, boolean expressionPossible) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/declaration/Declaration", "parseDeclarationWithGenerics"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/declaration/Declaration", "parseDeclarationWithGenerics"));
        }
        PsiBuilder.Marker start = builder.mark();
        IElementType type = Declaration.tryParseWithGenerics(builder, isInClass, isInAnnotation, typeDefinitionName, parser, modifiersParsed, expressionPossible, true);
        if (type == WRONGWAY || type == CONSTRUCTOR_DEFINITION || type == METHOD_DEFINITION) {
            start.drop();
            return type;
        }
        start.rollbackTo();
        return Declaration.tryParseWithGenerics(builder, isInClass, isInAnnotation, typeDefinitionName, parser, modifiersParsed, expressionPossible, false);
    }

    private static IElementType tryParseWithGenerics(@NotNull PsiBuilder builder, boolean isInClass, boolean isInAnnotation, @Nullable String typeDefinitionName, @NotNull GroovyParser parser, boolean modifiersParsed, boolean expressionPossible, boolean acceptTypeParameters) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/declaration/Declaration", "tryParseWithGenerics"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/declaration/Declaration", "tryParseWithGenerics"));
        }
        if (acceptTypeParameters) {
            TypeParameters.parse(builder);
        } else {
            PsiBuilder.Marker error = builder.mark();
            TypeParameters.parse(builder);
            error.error(GroovyBundle.message("type.parameters.are.unexpected", new Object[0]));
        }
        PsiBuilder.Marker checkMarker = builder.mark();
        switch (TypeSpec.parse(builder, false, expressionPossible)) {
            case PATH_REF: 
            case REF_WITH_TYPE_PARAMS: {
                checkMarker.drop();
                break;
            }
            case FAIL: {
                checkMarker.rollbackTo();
                break;
            }
            case IDENTIFIER: {
                IElementType result = VariableDefinitions.parseDefinitions(builder, isInClass, isInAnnotation, typeDefinitionName, modifiersParsed, false, parser);
                if (result == WRONGWAY) {
                    checkMarker.rollbackTo();
                    break;
                }
                checkMarker.drop();
                return result;
            }
        }
        return VariableDefinitions.parseDefinitions(builder, isInClass, isInAnnotation, typeDefinitionName, modifiersParsed, false, parser);
    }
}

