/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.constructor;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.Separators;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.blocks.OpenOrClosableBlock;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.arguments.ArgumentList;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class ConstructorBody
implements GroovyElementTypes {
    public static void parseConstructorBody(PsiBuilder builder, GroovyParser parser) {
        assert (builder.getTokenType() == mLCURLY);
        if (parser.parseDeep()) {
            ConstructorBody.parseConstructorBodyDeep(builder, parser);
        } else {
            OpenOrClosableBlock.parseBlockShallow(builder, (IElementType)CONSTRUCTOR_BODY);
        }
    }

    public static void parseConstructorBodyDeep(PsiBuilder builder, GroovyParser parser) {
        assert (builder.getTokenType() == mLCURLY);
        PsiBuilder.Marker cbMarker = builder.mark();
        builder.advanceLexer();
        ParserUtils.getToken(builder, mNLS);
        PsiBuilder.Marker constructorInvocationMarker = builder.mark();
        if (ConstructorBody.parseExplicitConstructor(builder, parser)) {
            constructorInvocationMarker.done((IElementType)EXPLICIT_CONSTRUCTOR);
        } else {
            constructorInvocationMarker.rollbackTo();
        }
        Separators.parse(builder);
        parser.parseBlockBody(builder);
        if (builder.getTokenType() != mRCURLY) {
            builder.error(GroovyBundle.message("rcurly.expected", new Object[0]));
        } else {
            builder.advanceLexer();
        }
        cbMarker.done((IElementType)CONSTRUCTOR_BODY);
    }

    private static boolean parseExplicitConstructor(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker marker;
        boolean result = false;
        if (ParserUtils.lookAhead(builder, kTHIS, mLPAREN)) {
            marker = builder.mark();
            ParserUtils.getToken(builder, kTHIS);
            marker.done((IElementType)REFERENCE_EXPRESSION);
            result = true;
        }
        if (ParserUtils.lookAhead(builder, kSUPER, mLPAREN)) {
            marker = builder.mark();
            ParserUtils.getToken(builder, kSUPER);
            marker.done((IElementType)REFERENCE_EXPRESSION);
            result = true;
        }
        if (result) {
            marker = builder.mark();
            ParserUtils.getToken(builder, mLPAREN);
            ArgumentList.parseArgumentList(builder, mRPAREN, parser);
            ParserUtils.getToken(builder, mRPAREN, GroovyBundle.message("rparen.expected", new Object[0]));
            marker.done((IElementType)ARGUMENTS);
            return true;
        }
        return false;
    }
}

