/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.blocks;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.parameters.ParameterList;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class OpenOrClosableBlock
implements GroovyElementTypes {
    public static boolean parseOpenBlock(PsiBuilder builder, GroovyParser parser) {
        if (builder.getTokenType() != mLCURLY) {
            return false;
        }
        if (parser.parseDeep()) {
            OpenOrClosableBlock.parseOpenBlockDeep(builder, parser);
        } else {
            OpenOrClosableBlock.parseBlockShallow(builder, (IElementType)OPEN_BLOCK);
        }
        return true;
    }

    public static void parseOpenBlockDeep(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        ParserUtils.getToken(builder, mNLS);
        parser.parseBlockBody(builder);
        if (!builder.eof() && builder.getTokenType() != mRCURLY) {
            builder.error(GroovyBundle.message("statement.expected", new Object[0]));
            ParserUtils.skipCountingBraces(builder, GroovyParser.RCURLY_ONLY);
        }
        ParserUtils.getToken(builder, mRCURLY, GroovyBundle.message("rcurly.expected", new Object[0]));
        marker.done((IElementType)OPEN_BLOCK);
    }

    public static IElementType parseClosableBlock(PsiBuilder builder, GroovyParser parser) {
        assert (builder.getTokenType() == mLCURLY) : builder.getTokenType();
        if (parser.parseDeep()) {
            OpenOrClosableBlock.parseClosableBlockDeep(builder, parser);
        } else {
            OpenOrClosableBlock.parseBlockShallow(builder, (IElementType)CLOSABLE_BLOCK);
        }
        return CLOSABLE_BLOCK;
    }

    public static void parseBlockShallow(PsiBuilder builder, IElementType blockType) {
        IElementType tokenType;
        PsiBuilder.Marker blockStart = builder.mark();
        int braceCount = 0;
        while ((tokenType = builder.getTokenType()) != null) {
            if (tokenType == mLCURLY) {
                ++braceCount;
            } else if (tokenType == mRCURLY) {
                --braceCount;
            }
            builder.advanceLexer();
            if (braceCount != 0) continue;
            break;
        }
        blockStart.collapse(blockType);
    }

    public static void parseClosableBlockDeep(PsiBuilder builder, GroovyParser parser) {
        assert (builder.getTokenType() == mLCURLY) : builder.getTokenType();
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        ParserUtils.getToken(builder, mNLS);
        OpenOrClosableBlock.closableBlockParamsOpt(builder, parser);
        parser.parseBlockBody(builder);
        ParserUtils.getToken(builder, mRCURLY, GroovyBundle.message("rcurly.expected", new Object[0]));
        marker.done((IElementType)CLOSABLE_BLOCK);
    }

    private static void closableBlockParamsOpt(PsiBuilder builder, GroovyParser parser) {
        ParameterList.parse(builder, mCLOSABLE_BLOCK_OP, parser);
        ParserUtils.getToken(builder, mNLS);
        ParserUtils.getToken(builder, mCLOSABLE_BLOCK_OP);
    }
}

