/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.modifiers.Modifiers;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.parameters.ParameterDeclaration;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.ConditionalExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.ExpressionStatement;
import org.jetbrains.plugins.groovy.lang.parser.parsing.types.TypeSpec;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class ForStatement
implements GroovyElementTypes {
    public static boolean forClauseParse(PsiBuilder builder, GroovyParser parser) {
        ParserUtils.getToken(builder, mNLS);
        return ForStatement.forInClauseParse(builder, parser) || ForStatement.tradForClauseParse(builder, parser);
    }

    private static boolean tradForClauseParse(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker marker = builder.mark();
        if (!ParameterDeclaration.parseTraditionalForParameter(builder, parser)) {
            marker.rollbackTo();
            marker = builder.mark();
            ExpressionStatement.argParse(builder, parser);
        }
        ParserUtils.getToken(builder, mSEMI, GroovyBundle.message("semi.expected", new Object[0]));
        ExpressionStatement.argParse(builder, parser);
        ParserUtils.getToken(builder, mSEMI, GroovyBundle.message("semi.expected", new Object[0]));
        ParserUtils.getToken(builder, mNLS);
        if (!mRPAREN.equals(builder.getTokenType())) {
            ExpressionStatement.argParse(builder, parser);
        }
        marker.done((IElementType)FOR_TRADITIONAL_CLAUSE);
        return true;
    }

    private static boolean forInClauseParse(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker marker = builder.mark();
        PsiBuilder.Marker paramMarker = builder.mark();
        Modifiers.parse(builder, parser);
        boolean isBuiltInType = TokenSets.BUILT_IN_TYPES.contains(builder.getTokenType());
        PsiBuilder.Marker typeSpec = builder.mark();
        TypeSpec.parseStrict(builder, false);
        if (builder.getTokenType() == mIDENT || isBuiltInType) {
            typeSpec.drop();
        } else {
            typeSpec.rollbackTo();
        }
        if (TokenSets.FOR_IN_DELIMITERS.contains(builder.getTokenType())) {
            builder.error(GroovyBundle.message("identifier.expected", new Object[0]));
            paramMarker.drop();
        } else if (builder.getTokenType() == mIDENT) {
            ParserUtils.getToken(builder, mIDENT);
            paramMarker.done((IElementType)PARAMETER);
        } else {
            paramMarker.drop();
            marker.rollbackTo();
            return false;
        }
        if (!ParserUtils.getToken(builder, kIN) && !ParserUtils.getToken(builder, mCOLON)) {
            marker.rollbackTo();
            return false;
        }
        if (!ConditionalExpression.parse(builder, parser)) {
            builder.error(GroovyBundle.message("expression.expected", new Object[0]));
        }
        marker.done((IElementType)FOR_IN_CLAUSE);
        return true;
    }
}

