/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.annotations;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.annotations.Annotation;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.ConditionalExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class AnnotationArguments
implements GroovyElementTypes {
    public static void parse(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker annArgs = builder.mark();
        if (!ParserUtils.getToken(builder, mLPAREN)) {
            annArgs.done((IElementType)ANNOTATION_ARGUMENTS);
            return;
        }
        if (builder.getTokenType() != mRPAREN) {
            AnnotationArguments.parsePairs(builder, parser);
        }
        ParserUtils.getToken(builder, mNLS);
        ParserUtils.getToken(builder, mRPAREN, GroovyBundle.message("rparen.expected", new Object[0]));
        annArgs.done((IElementType)ANNOTATION_ARGUMENTS);
    }

    private static boolean checkIdentAndAssign(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        boolean result = ParserUtils.getToken(builder, TokenSets.CODE_REFERENCE_ELEMENT_NAME_TOKENS) && ParserUtils.getToken(builder, mASSIGN);
        marker.rollbackTo();
        return result;
    }

    public static boolean parseAnnotationMemberValueInitializer(PsiBuilder builder, GroovyParser parser) {
        if (builder.getTokenType() == mAT) {
            return Annotation.parse(builder, parser);
        }
        if (builder.getTokenType() == mLBRACK) {
            PsiBuilder.Marker marker = builder.mark();
            ParserUtils.getToken(builder, mLBRACK);
            while (AnnotationArguments.parseAnnotationMemberValueInitializer(builder, parser) && !builder.eof() && builder.getTokenType() != mRBRACK) {
                ParserUtils.getToken(builder, mCOMMA, GroovyBundle.message("comma.expected", new Object[0]));
            }
            ParserUtils.getToken(builder, mRBRACK, GroovyBundle.message("rbrack.expected", new Object[0]));
            marker.done((IElementType)ANNOTATION_ARRAY_INITIALIZER);
            return true;
        }
        return ConditionalExpression.parse(builder, parser) && !ParserUtils.getToken(builder, mASSIGN);
    }

    private static boolean parsePairs(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker start = builder.mark();
        if (!AnnotationArguments.parsePair(builder, parser)) {
            start.rollbackTo();
            return false;
        }
        while (ParserUtils.getToken(builder, mCOMMA)) {
            ParserUtils.getToken(builder, mNLS);
            AnnotationArguments.parsePair(builder, parser);
        }
        start.drop();
        return true;
    }

    private static boolean parsePair(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker lfMarker;
        PsiBuilder.Marker marker = builder.mark();
        if (AnnotationArguments.checkIdentAndAssign(builder)) {
            ParserUtils.getToken(builder, TokenSets.CODE_REFERENCE_ELEMENT_NAME_TOKENS);
            ParserUtils.getToken(builder, mASSIGN);
            lfMarker = builder.mark();
            ParserUtils.getToken(builder, mNLS);
        } else {
            lfMarker = null;
        }
        if (!AnnotationArguments.parseAnnotationMemberValueInitializer(builder, parser)) {
            if (lfMarker != null) {
                lfMarker.rollbackTo();
                builder.error(GroovyBundle.message("annotation.member.value.initializer.expected", new Object[0]));
            } else {
                builder.error(GroovyBundle.message("annotation.attribute.expected", new Object[0]));
            }
        } else if (lfMarker != null) {
            lfMarker.drop();
        }
        marker.done((IElementType)ANNOTATION_MEMBER_VALUE_PAIR);
        return true;
    }
}

