/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.annotations;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.annotations.AnnotationArguments;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.typeDefinitions.ReferenceElement;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class Annotation
implements GroovyElementTypes {
    public static boolean parse(PsiBuilder builder, GroovyParser parser) {
        if (builder.getTokenType() != mAT) {
            return false;
        }
        PsiBuilder.Marker annMarker = builder.mark();
        builder.advanceLexer();
        if (builder.getTokenType() == kINTERFACE) {
            annMarker.rollbackTo();
            return false;
        }
        if (ReferenceElement.parse(builder, false, true, true, false, false) == ReferenceElement.ReferenceElementResult.FAIL) {
            builder.error("Annotation name expected");
            annMarker.drop();
            return false;
        }
        if (ParserUtils.lookAhead(builder, mNLS, mLPAREN)) {
            ParserUtils.getToken(builder, mNLS);
        }
        AnnotationArguments.parse(builder, parser);
        annMarker.done((IElementType)ANNOTATION);
        return true;
    }

    public static void parseAnnotationOptional(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker annOptMarker = builder.mark();
        boolean hasAnnotations = false;
        while (Annotation.parse(builder, parser)) {
            ParserUtils.getToken(builder, mNLS);
            hasAnnotations = true;
        }
        if (hasAnnotations) {
            annOptMarker.done((IElementType)MODIFIERS);
        } else {
            annOptMarker.rollbackTo();
        }
    }
}

