/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parameterInfo;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;

public class GroovyTypeParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<GrTypeArgumentList, PsiTypeParameter, GrTypeElement> {
    private static final Set<Class> ALLOWED_PARENT_CLASSES = ContainerUtil.newHashSet((Object[])new Class[]{GrCodeReferenceElement.class});
    private static final Set<Class> STOP_SEARCHING_CLASSES = ContainerUtil.newHashSet((Object[])new Class[]{GroovyFile.class});

    @NotNull
    public GrTypeElement[] getActualParameters(@NotNull GrTypeArgumentList o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyTypeParameterInfoHandler", "getActualParameters"));
        }
        GrTypeElement[] grTypeElementArray = o.getTypeArgumentElements();
        if (grTypeElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyTypeParameterInfoHandler", "getActualParameters"));
        }
        return grTypeElementArray;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        IElementType iElementType = GroovyTokenTypes.mCOMMA;
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyTypeParameterInfoHandler", "getActualParameterDelimiterType"));
        }
        return iElementType;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        IElementType iElementType = GroovyTokenTypes.mGT;
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyTypeParameterInfoHandler", "getActualParametersRBraceType"));
        }
        return iElementType;
    }

    @NotNull
    public Set<Class> getArgumentListAllowedParentClasses() {
        Set<Class> set = ALLOWED_PARENT_CLASSES;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyTypeParameterInfoHandler", "getArgumentListAllowedParentClasses"));
        }
        return set;
    }

    @NotNull
    public Set<? extends Class> getArgListStopSearchClasses() {
        Set<Class> set = STOP_SEARCHING_CLASSES;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyTypeParameterInfoHandler", "getArgListStopSearchClasses"));
        }
        return set;
    }

    @NotNull
    public Class<GrTypeArgumentList> getArgumentListClass() {
        if (GrTypeArgumentList.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyTypeParameterInfoHandler", "getArgumentListClass"));
        }
        return GrTypeArgumentList.class;
    }

    public boolean couldShowInLookup() {
        return false;
    }

    @Nullable
    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        return null;
    }

    @Nullable
    public Object[] getParametersForDocumentation(PsiTypeParameter p, ParameterInfoContext context) {
        return new Object[]{p};
    }

    @Nullable
    public GrTypeArgumentList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyTypeParameterInfoHandler", "findElementForParameterInfo"));
        }
        GrTypeArgumentList parameterList = (GrTypeArgumentList)ParameterInfoUtils.findParentOfType((PsiFile)context.getFile(), (int)context.getOffset(), GrTypeArgumentList.class);
        if (parameterList != null) {
            if (!(parameterList.getParent() instanceof GrCodeReferenceElement)) {
                return null;
            }
            GrCodeReferenceElement ref = (GrCodeReferenceElement)parameterList.getParent();
            PsiElement resolved = ref.resolve();
            if (!(resolved instanceof PsiTypeParameterListOwner)) {
                return null;
            }
            Object[] typeParams = ((PsiTypeParameterListOwner)resolved).getTypeParameters();
            if (typeParams.length == 0) {
                return null;
            }
            context.setItemsToShow(typeParams);
            return parameterList;
        }
        return null;
    }

    public void showParameterInfo(@NotNull GrTypeArgumentList element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyTypeParameterInfoHandler", "showParameterInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyTypeParameterInfoHandler", "showParameterInfo"));
        }
        context.showHint((PsiElement)element, element.getTextRange().getStartOffset() + 1, (ParameterInfoHandler)this);
    }

    @Nullable
    public GrTypeArgumentList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyTypeParameterInfoHandler", "findElementForUpdatingParameterInfo"));
        }
        return (GrTypeArgumentList)ParameterInfoUtils.findParentOfType((PsiFile)context.getFile(), (int)context.getOffset(), GrTypeArgumentList.class);
    }

    public void updateParameterInfo(@NotNull GrTypeArgumentList parameterOwner, @NotNull UpdateParameterInfoContext context) {
        if (parameterOwner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyTypeParameterInfoHandler", "updateParameterInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyTypeParameterInfoHandler", "updateParameterInfo"));
        }
        int index = ParameterInfoUtils.getCurrentParameterIndex((ASTNode)parameterOwner.getNode(), (int)context.getOffset(), (IElementType)this.getActualParameterDelimiterType());
        context.setCurrentParameter(index);
        Object[] objectsToView = context.getObjectsToView();
        context.setHighlightedParameter(index < objectsToView.length && index >= 0 ? (PsiElement)objectsToView[index] : null);
    }

    @Nullable
    public String getParameterCloseChars() {
        return ",>";
    }

    public boolean tracksParameterIndex() {
        return false;
    }

    public void updateUI(PsiTypeParameter p, @NotNull ParameterInfoUIContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyTypeParameterInfoHandler", "updateUI"));
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(p.getName());
        int highlightEndOffset = buffer.length();
        buffer.append(" extends ");
        buffer.append(StringUtil.join((Object[])p.getSuperTypes(), (Function)new Function<PsiClassType, String>(){

            public String fun(PsiClassType t) {
                return t.getPresentableText();
            }
        }, (String)", "));
        context.setupUIComponentPresentation(buffer.toString(), 0, highlightEndOffset, false, false, false, context.getDefaultParameterColor());
    }
}

