/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parameterInfo;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.Collections;
import java.util.Set;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;

public class GroovyAnnotationAttributeInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<GrAnnotationArgumentList, PsiAnnotationMethod, GrAnnotationNameValuePair> {
    private static final Set<Class> ALLOWED_CLASSES = ContainerUtil.newHashSet((Object[])new Class[]{GrAnnotation.class});
    private static final Set<Class<GroovyFile>> STOP_SEARCHING_CLASSES = Collections.singleton(GroovyFile.class);

    @NotNull
    public GrAnnotationNameValuePair[] getActualParameters(@NotNull GrAnnotationArgumentList o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyAnnotationAttributeInfoHandler", "getActualParameters"));
        }
        GrAnnotationNameValuePair[] grAnnotationNameValuePairArray = o.getAttributes();
        if (grAnnotationNameValuePairArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyAnnotationAttributeInfoHandler", "getActualParameters"));
        }
        return grAnnotationNameValuePairArray;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        IElementType iElementType = GroovyTokenTypes.mCOMMA;
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyAnnotationAttributeInfoHandler", "getActualParameterDelimiterType"));
        }
        return iElementType;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        IElementType iElementType = GroovyTokenTypes.mRPAREN;
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyAnnotationAttributeInfoHandler", "getActualParametersRBraceType"));
        }
        return iElementType;
    }

    @NotNull
    public Set<Class> getArgumentListAllowedParentClasses() {
        Set<Class> set = ALLOWED_CLASSES;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyAnnotationAttributeInfoHandler", "getArgumentListAllowedParentClasses"));
        }
        return set;
    }

    @NotNull
    public Set<? extends Class> getArgListStopSearchClasses() {
        Set<Class<GroovyFile>> set = STOP_SEARCHING_CLASSES;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyAnnotationAttributeInfoHandler", "getArgListStopSearchClasses"));
        }
        return set;
    }

    @NotNull
    public Class<GrAnnotationArgumentList> getArgumentListClass() {
        if (GrAnnotationArgumentList.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyAnnotationAttributeInfoHandler", "getArgumentListClass"));
        }
        return GrAnnotationArgumentList.class;
    }

    public boolean couldShowInLookup() {
        return true;
    }

    public Object[] getParametersForLookup(@NotNull LookupElement item, @NotNull ParameterInfoContext context) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyAnnotationAttributeInfoHandler", "getParametersForLookup"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyAnnotationAttributeInfoHandler", "getParametersForLookup"));
        }
        Object o = item.getObject();
        if (o instanceof GroovyResolveResult) {
            o = ((GroovyResolveResult)o).getElement();
        }
        if (o instanceof PsiAnnotationMethod) {
            return ((PsiAnnotationMethod)o).getParameterList().getParameters();
        }
        return GrAnnotationNameValuePair.EMPTY_ARRAY;
    }

    public Object[] getParametersForDocumentation(@NotNull PsiAnnotationMethod method, @NotNull ParameterInfoContext context) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyAnnotationAttributeInfoHandler", "getParametersForDocumentation"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyAnnotationAttributeInfoHandler", "getParametersForDocumentation"));
        }
        return new PsiAnnotationMethod[]{method};
    }

    public GrAnnotationArgumentList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyAnnotationAttributeInfoHandler", "findElementForParameterInfo"));
        }
        return GroovyAnnotationAttributeInfoHandler.findAnchor(context.getEditor(), context.getFile());
    }

    @Nullable
    private static GrAnnotationArgumentList findAnchor(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyAnnotationAttributeInfoHandler", "findAnchor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyAnnotationAttributeInfoHandler", "findAnchor"));
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        if (element == null) {
            return null;
        }
        return (GrAnnotationArgumentList)PsiTreeUtil.getParentOfType((PsiElement)element, GrAnnotationArgumentList.class);
    }

    public void showParameterInfo(@NotNull GrAnnotationArgumentList argumentList, @NotNull CreateParameterInfoContext context) {
        if (argumentList == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyAnnotationAttributeInfoHandler", "showParameterInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyAnnotationAttributeInfoHandler", "showParameterInfo"));
        }
        GrAnnotation parent = (GrAnnotation)DefaultGroovyMethods.asType((Object)argumentList.getParent(), GrAnnotation.class);
        PsiElement resolved = parent.getClassReference().resolve();
        if (resolved instanceof PsiClass && ((PsiClass)resolved).isAnnotationType()) {
            Object[] methods = ((PsiClass)resolved).getMethods();
            context.setItemsToShow(methods);
            context.showHint((PsiElement)argumentList, argumentList.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
            PsiAnnotationMethod currentMethod = GroovyAnnotationAttributeInfoHandler.findAnnotationMethod(context.getFile(), context.getEditor());
            if (currentMethod != null) {
                context.setHighlightedElement((PsiElement)currentMethod);
            }
        }
    }

    @Nullable
    private static PsiAnnotationMethod findAnnotationMethod(@NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyAnnotationAttributeInfoHandler", "findAnnotationMethod"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyAnnotationAttributeInfoHandler", "findAnnotationMethod"));
        }
        PsiNameValuePair pair = (PsiNameValuePair)ParameterInfoUtils.findParentOfType((PsiFile)file, (int)GroovyAnnotationAttributeInfoHandler.inferOffset(editor), PsiNameValuePair.class);
        if (pair == null) {
            return null;
        }
        PsiReference reference = pair.getReference();
        PsiElement resolved = reference != null ? reference.resolve() : null;
        return PsiUtil.isAnnotationMethod((PsiElement)resolved) ? (PsiAnnotationMethod)resolved : null;
    }

    public GrAnnotationArgumentList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyAnnotationAttributeInfoHandler", "findElementForUpdatingParameterInfo"));
        }
        return GroovyAnnotationAttributeInfoHandler.findAnchor(context.getEditor(), context.getFile());
    }

    public void updateParameterInfo(@NotNull GrAnnotationArgumentList parameterOwner, @NotNull UpdateParameterInfoContext context) {
        if (parameterOwner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyAnnotationAttributeInfoHandler", "updateParameterInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyAnnotationAttributeInfoHandler", "updateParameterInfo"));
        }
        context.setHighlightedParameter((Object)GroovyAnnotationAttributeInfoHandler.findAnnotationMethod(context.getFile(), context.getEditor()));
    }

    private static int inferOffset(@NotNull Editor editor) {
        int offset1;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyAnnotationAttributeInfoHandler", "inferOffset"));
        }
        CharSequence chars = editor.getDocument().getCharsSequence();
        char character = chars.charAt(offset1 = CharArrayUtil.shiftForward((CharSequence)chars, (int)editor.getCaretModel().getOffset(), (String)" \t"));
        if (character == ',' || character == ')') {
            offset1 = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset1 - 1), (String)" \t");
        }
        return offset1;
    }

    public String getParameterCloseChars() {
        return ",){}";
    }

    public boolean tracksParameterIndex() {
        return true;
    }

    public void updateUI(@NotNull PsiAnnotationMethod p, @NotNull ParameterInfoUIContext context) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyAnnotationAttributeInfoHandler", "updateUI"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyAnnotationAttributeInfoHandler", "updateUI"));
        }
        StringBuilder buffer = new StringBuilder();
        PsiType returnType = p.getReturnType();
        assert (returnType != null);
        buffer.append(returnType.getPresentableText());
        buffer.append(" ");
        int highlightStartOffset = buffer.length();
        buffer.append(p.getName());
        int highlightEndOffset = buffer.length();
        buffer.append("()");
        PsiAnnotationMemberValue defaultValue = p.getDefaultValue();
        if (defaultValue != null) {
            buffer.append(" default ");
            buffer.append(defaultValue.getText());
        }
        context.setupUIComponentPresentation(buffer.toString(), highlightStartOffset, highlightEndOffset, false, p.isDeprecated(), false, context.getDefaultParameterColor());
    }
}

