/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.groovydoc.parser.elements;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.HashSet;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.groovydoc.lexer.GroovyDocTokenTypes;
import org.jetbrains.plugins.groovy.lang.groovydoc.lexer.IGroovyDocElementType;
import org.jetbrains.plugins.groovy.lang.groovydoc.parser.elements.GroovyDocChameleonElementType;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocInlinedTag;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMemberReference;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMethodParameter;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTag;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyLexer;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.typeDefinitions.ReferenceElement;

public class GroovyDocTagValueTokenType
extends GroovyDocChameleonElementType
implements IGroovyDocElementType {
    private static final Set<String> TAGS_WITH_REFERENCES = new HashSet();
    private static final Set<String> INLINED_TAGS_WITH_REFERENCES = new HashSet();
    private static final Set<String> BUILT_IN_TYPES = new HashSet();

    public GroovyDocTagValueTokenType() {
        super("GDOC_TAG_VALUE_TOKEN");
    }

    public static TagValueTokenType getValueType(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/groovydoc/parser/elements/GroovyDocTagValueTokenType", "getValueType"));
        }
        return GroovyDocTagValueTokenType.isReferenceElement(node.getTreeParent(), node) ? TagValueTokenType.REFERENCE_ELEMENT : TagValueTokenType.VALUE_TOKEN;
    }

    public ASTNode parseContents(ASTNode chameleon) {
        ASTNode parent = chameleon.getTreeParent();
        if (GroovyDocTagValueTokenType.isReferenceElement(parent, chameleon)) {
            return this.parseImpl(chameleon);
        }
        return GroovyDocTagValueTokenType.getPlainValueToken(chameleon);
    }

    private static boolean isReferenceElement(ASTNode parent, ASTNode child) {
        if (parent != null && child != null) {
            String name;
            PsiElement parentPsi = parent.getPsi();
            if (parentPsi instanceof GrDocTag && (TAGS_WITH_REFERENCES.contains(name = ((GrDocTag)parentPsi).getName()) && !(parentPsi instanceof GrDocInlinedTag) || INLINED_TAGS_WITH_REFERENCES.contains(name) && parentPsi instanceof GrDocInlinedTag)) {
                return parent.findChildByType(GroovyDocTokenTypes.mGDOC_TAG_VALUE_TOKEN) == child;
            }
            if (parentPsi instanceof GrDocMethodParameter && parent.findChildByType(GroovyDocTokenTypes.mGDOC_TAG_VALUE_TOKEN) == child) {
                return true;
            }
            if (parentPsi instanceof GrDocMemberReference) {
                ASTNode prev = child.getTreePrev();
                if (prev != null && prev.getElementType() == GroovyDocTokenTypes.mGDOC_TAG_VALUE_SHARP_TOKEN) {
                    return false;
                }
                return parent.findChildByType(GroovyDocTokenTypes.mGDOC_TAG_VALUE_TOKEN) == child;
            }
        }
        return false;
    }

    private static ASTNode getPlainValueToken(ASTNode chameleon) {
        return new LeafPsiElement(GroovyDocTokenTypes.mGDOC_TAG_PLAIN_VALUE_TOKEN, (CharSequence)chameleon.getText());
    }

    private ASTNode parseImpl(ASTNode chameleon) {
        PsiElement parentElement = chameleon.getTreeParent().getPsi();
        Project project = parentElement.getProject();
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(project, chameleon, (Lexer)new GroovyLexer(), this.getLanguage(), (CharSequence)chameleon.getText());
        PsiBuilder.Marker rootMarker = builder.mark();
        if (BUILT_IN_TYPES.contains(chameleon.getText())) {
            builder.advanceLexer();
        } else {
            ReferenceElement.parse(builder, false, false, false, false, false);
            while (!builder.eof()) {
                builder.advanceLexer();
            }
        }
        rootMarker.done((IElementType)this);
        return builder.getTreeBuilt().getFirstChildNode();
    }

    static {
        BUILT_IN_TYPES.addAll(Arrays.asList("double", "long", "float", "short", "any", "char", "int", "byte", "boolean"));
        TAGS_WITH_REFERENCES.addAll(Arrays.asList("see", "throws", "exception"));
        INLINED_TAGS_WITH_REFERENCES.addAll(Arrays.asList("link", "linkplain", "value"));
    }

    public static enum TagValueTokenType {
        REFERENCE_ELEMENT,
        VALUE_TOKEN;

    }
}

