/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.PairConsumer;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.configSlurper.ConfigSlurperSupport;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

class GroovyConfigSlurperCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private final boolean myAddPrefixes;

    GroovyConfigSlurperCompletionProvider(boolean addPrefixes) {
        this.myAddPrefixes = addPrefixes;
    }

    public static void register(CompletionContributor contributor) {
        PsiElementPattern.Capture pattern = (PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(GrReferenceExpression.class));
        contributor.extend(CompletionType.BASIC, (ElementPattern)pattern, (CompletionProvider)new GroovyConfigSlurperCompletionProvider(true));
        contributor.extend(CompletionType.SMART, (ElementPattern)pattern, (CompletionProvider)new GroovyConfigSlurperCompletionProvider(false));
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        int dotIndex;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/completion/GroovyConfigSlurperCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/completion/GroovyConfigSlurperCompletionProvider", "addCompletions"));
        }
        PsiFile file = parameters.getOriginalFile();
        if (!(file instanceof GroovyFile)) {
            return;
        }
        GroovyFile groovyFile = (GroovyFile)file;
        if (!groovyFile.isScript()) {
            return;
        }
        GrReferenceExpression ref = (GrReferenceExpression)parameters.getPosition().getParent();
        if (ref == null) {
            return;
        }
        final HashMap variants = new HashMap();
        GroovyConfigSlurperCompletionProvider.collectVariants(new PairConsumer<String, Boolean>(){

            public void consume(String s, Boolean isFinal) {
                variants.put(s, isFinal);
            }
        }, ref, groovyFile);
        if (variants.isEmpty()) {
            return;
        }
        PsiElement parent = ref.getParent();
        if (parent instanceof GrAssignmentExpression) {
            parent = parent.getParent();
        }
        if (parent == null) {
            return;
        }
        HashSet<String> processedPrefixes = new HashSet<String>();
        HashSet<String> prefixesInMethodCall = new HashSet<String>();
        for (PsiElement e = parent.getFirstChild(); e != null; e = e.getNextSibling()) {
            String name;
            GrMethodCall call;
            if (e instanceof GrAssignmentExpression) {
                String s;
                GrExpression left = ((GrAssignmentExpression)e).getLValue();
                if (!(left instanceof GrReferenceExpression) || (s = GroovyConfigSlurperCompletionProvider.refToString((GrReferenceExpression)left)) == null) continue;
                dotIndex = s.indexOf(46);
                if (dotIndex > 0) {
                    processedPrefixes.add(s.substring(0, dotIndex));
                }
                variants.remove(s);
                continue;
            }
            if (!(e instanceof GrMethodCall) || !GroovyConfigSlurperCompletionProvider.isPropertyCall(call = (GrMethodCall)e) || (name = GroovyConfigSlurperCompletionProvider.extractPropertyName(call)) == null) continue;
            processedPrefixes.add(name);
            prefixesInMethodCall.add(name);
            variants.remove(name);
        }
        for (Map.Entry entry : variants.entrySet()) {
            String variant = (String)entry.getKey();
            dotIndex = variant.indexOf(46);
            if (dotIndex > 0 && dotIndex < variant.length() - 1) {
                String p = variant.substring(0, dotIndex);
                if (prefixesInMethodCall.contains(p)) continue;
                if (this.myAddPrefixes && processedPrefixes.add(p)) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)p));
                }
            }
            LookupElementBuilder lookupElement = LookupElementBuilder.create((String)variant);
            if (((Boolean)entry.getValue()).booleanValue()) {
                lookupElement = TailTypeDecorator.withTail((LookupElement)lookupElement, (TailType)TailType.EQ);
            }
            result.addElement((LookupElement)lookupElement);
        }
    }

    private static void collectVariants(@NotNull PairConsumer<String, Boolean> consumer, @NotNull GrReferenceExpression ref, @NotNull GroovyFile originalFile) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/completion/GroovyConfigSlurperCompletionProvider", "collectVariants"));
        }
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/completion/GroovyConfigSlurperCompletionProvider", "collectVariants"));
        }
        if (originalFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/completion/GroovyConfigSlurperCompletionProvider", "collectVariants"));
        }
        List<String> prefix = GroovyConfigSlurperCompletionProvider.getPrefix(ref);
        if (prefix == null) {
            return;
        }
        for (ConfigSlurperSupport configSlurperSupport : (ConfigSlurperSupport[])ConfigSlurperSupport.EP_NAME.getExtensions()) {
            ConfigSlurperSupport.PropertiesProvider provider = configSlurperSupport.getProvider(originalFile);
            if (provider == null) continue;
            provider.collectVariants(prefix, consumer);
        }
    }

    @Nullable
    private static String refToString(GrReferenceExpression ref) {
        StringBuilder sb = new StringBuilder();
        while (ref != null) {
            String name = ref.getReferenceName();
            if (name == null) {
                return null;
            }
            int i = name.length();
            while (--i >= 0) {
                sb.append(name.charAt(i));
            }
            GrExpression qualifierExpression = ref.getQualifierExpression();
            if (qualifierExpression == null) break;
            if (!(qualifierExpression instanceof GrReferenceExpression)) {
                return null;
            }
            sb.append('.');
            ref = (GrReferenceExpression)qualifierExpression;
        }
        sb.reverse();
        return sb.toString();
    }

    @Nullable
    public static List<String> getPrefix(GrReferenceExpression ref) {
        ArrayList<String> res = new ArrayList<String>();
        GrExpression qualifier = ref.getQualifierExpression();
        while (qualifier != null) {
            if (!(qualifier instanceof GrReferenceExpression)) {
                return null;
            }
            GrReferenceExpression r = (GrReferenceExpression)qualifier;
            String name = r.getReferenceName();
            if (name == null) {
                return null;
            }
            res.add(name);
            qualifier = r.getQualifierExpression();
        }
        PsiElement e = ref.getParent();
        if (e instanceof GrAssignmentExpression) {
            GrAssignmentExpression assignmentExpression = (GrAssignmentExpression)e;
            if (assignmentExpression.getLValue() != ref) {
                return null;
            }
            e = assignmentExpression.getParent();
        }
        while (!(e instanceof PsiFile)) {
            if (e instanceof GrClosableBlock) {
                PsiElement eCall = e.getParent();
                if (!(eCall instanceof GrMethodCall)) {
                    return null;
                }
                GrMethodCall call = (GrMethodCall)eCall;
                if (!GroovyConfigSlurperCompletionProvider.isPropertyCall(call)) {
                    return null;
                }
                String name = GroovyConfigSlurperCompletionProvider.extractPropertyName(call);
                if (name == null) {
                    return null;
                }
                res.add(name);
                e = call.getParent();
                continue;
            }
            if (e instanceof GrBlockStatement || e instanceof GrOpenBlock || e instanceof GrIfStatement || e instanceof GrForStatement || e instanceof GrWhileStatement || e instanceof GrTryCatchStatement) {
                e = e.getParent();
                continue;
            }
            return null;
        }
        Collections.reverse(res);
        return res;
    }

    @Nullable
    private static String extractPropertyName(GrMethodCall call) {
        GrExpression ie = call.getInvokedExpression();
        if (ie instanceof GrReferenceExpression) {
            GrReferenceExpression r = (GrReferenceExpression)ie;
            if (r.isQualified()) {
                return null;
            }
            return r.getReferenceName();
        }
        if (ie instanceof GrLiteralImpl) {
            Object value = ((GrLiteralImpl)ie).getValue();
            if (!(value instanceof String)) {
                return null;
            }
            return (String)value;
        }
        return null;
    }

    private static boolean isPropertyCall(GrMethodCall call) {
        GrExpression[] arguments = PsiUtil.getAllArguments(call);
        return arguments.length == 1 && arguments[0] instanceof GrClosableBlock;
    }
}

