/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.TailTypes;
import com.intellij.codeInsight.completion.AllClassesGetter;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InheritorsHolder;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaCompletionContributor;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaGlobalMemberLookupElement;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.StaticMemberProcessor;
import com.intellij.codeInsight.completion.WordCompletionContributor;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.filters.FilterPositionUtil;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.completion.GroovyClassNameInsertHandler;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionData;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.completion.GroovyConfigSlurperCompletionProvider;
import org.jetbrains.plugins.groovy.lang.completion.GroovyDocCompletionProvider;
import org.jetbrains.plugins.groovy.lang.completion.GroovyInsertHandler;
import org.jetbrains.plugins.groovy.lang.completion.GroovySmartCompletionContributor;
import org.jetbrains.plugins.groovy.lang.completion.MapArgumentCompletionProvider;
import org.jetbrains.plugins.groovy.lang.completion.MapKeysCompletionProvider;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameterList;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.CompleteReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.DefaultGroovyVariableNameValidator;
import org.jetbrains.plugins.groovy.refactoring.GroovyNameSuggestionUtil;
import org.jetbrains.plugins.groovy.refactoring.inline.InlineMethodConflictSolver;

public class GroovyCompletionContributor
extends CompletionContributor {
    private static final ElementPattern<PsiElement> AFTER_DOT = ((PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf(new String[]{"."})).withParent(GrReferenceExpression.class);
    private static final String[] THIS_SUPER = new String[]{"this", "super"};
    private static final InsertHandler<JavaGlobalMemberLookupElement> STATIC_IMPORT_INSERT_HANDLER = new InsertHandler<JavaGlobalMemberLookupElement>(){

        public void handleInsert(InsertionContext context, JavaGlobalMemberLookupElement item) {
            GroovyInsertHandler.INSTANCE.handleInsert(context, (LookupElement)item);
            PsiMember member = item.getObject();
            PsiDocumentManager.getInstance((Project)member.getProject()).commitDocument(context.getDocument());
            GrReferenceExpression ref = (GrReferenceExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), GrReferenceExpression.class, (boolean)false);
            if (ref != null && ref.getQualifier() == null && context.getFile() instanceof GroovyFile && !GroovyCompletionContributor.importAlreadyExists(member, (GroovyFile)context.getFile(), ref) && !PsiManager.getInstance((Project)context.getProject()).areElementsEquivalent(ref.resolve(), (PsiElement)member)) {
                ref.bindToElementViaStaticImport(member);
            }
        }
    };
    private static final InsertHandler<JavaGlobalMemberLookupElement> QUALIFIED_METHOD_INSERT_HANDLER = new InsertHandler<JavaGlobalMemberLookupElement>(){

        public void handleInsert(InsertionContext context, JavaGlobalMemberLookupElement item) {
            GroovyInsertHandler.INSTANCE.handleInsert(context, (LookupElement)item);
            PsiClass containingClass = item.getContainingClass();
            context.getDocument().insertString(context.getStartOffset(), (CharSequence)(containingClass.getName() + "."));
            PsiDocumentManager.getInstance((Project)containingClass.getProject()).commitDocument(context.getDocument());
            GrReferenceExpression ref = (GrReferenceExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), GrReferenceExpression.class, (boolean)false);
            if (ref != null) {
                ref.bindToElement((PsiElement)containingClass);
            }
        }
    };
    private static final PsiElementPattern.Capture<PsiElement> STATEMENT_START = (PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)GroovyTokenTypes.mIDENT).andOr(new ElementPattern[]{((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement().isNull(), PlatformPatterns.psiElement().withElementType(TokenSets.SEPARATORS), PlatformPatterns.psiElement((IElementType)GroovyTokenTypes.mLCURLY), PlatformPatterns.psiElement((IElementType)GroovyTokenTypes.kELSE)}))).andNot((ElementPattern)PlatformPatterns.psiElement().withParent(GrTypeDefinitionBody.class))).andNot((ElementPattern)PlatformPatterns.psiElement(PsiErrorElement.class)), ((PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)GroovyTokenTypes.mRPAREN))).withSuperParent(2, StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement(GrForStatement.class), PlatformPatterns.psiElement(GrWhileStatement.class), PlatformPatterns.psiElement(GrIfStatement.class)}))});
    private static final ElementPattern<PsiElement> AFTER_NUMBER_LITERAL = PlatformPatterns.psiElement().afterLeafSkipping(StandardPatterns.alwaysFalse(), (ElementPattern)PlatformPatterns.psiElement().withElementType((ElementPattern)PsiJavaPatterns.elementType().oneOf((Object[])new IElementType[]{GroovyTokenTypes.mNUM_DOUBLE, GroovyTokenTypes.mNUM_INT, GroovyTokenTypes.mNUM_LONG, GroovyTokenTypes.mNUM_FLOAT, GroovyTokenTypes.mNUM_BIG_INT, GroovyTokenTypes.mNUM_BIG_DECIMAL})));
    public static final ElementPattern<PsiElement> AFTER_AT = PlatformPatterns.psiElement().afterLeaf(new String[]{"@"});
    public static final ElementPattern<PsiElement> IN_CATCH_TYPE = PlatformPatterns.psiElement().afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("(")).withParent(GrCatchClause.class));
    private static final String DUMMY_IDENTIFIER_DECAPITALIZED = StringUtil.decapitalize((String)"IntellijIdeaRulezzz ");

    private static boolean importAlreadyExists(final PsiMember member, GroovyFile file, PsiElement place) {
        final PsiManager manager = file.getManager();
        PsiScopeProcessor processor = new PsiScopeProcessor(){

            public boolean execute(@NotNull PsiElement element, ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionContributor$2", "execute"));
                }
                return !manager.areElementsEquivalent(element, (PsiElement)member);
            }

            public <T> T getHint(@NotNull Key<T> hintKey) {
                if (hintKey == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionContributor$2", "getHint"));
                }
                return null;
            }

            public void handleEvent(PsiScopeProcessor.Event event, Object associated) {
            }
        };
        boolean skipStaticImports = member instanceof PsiClass;
        GrImportStatement[] imports = file.getImportStatements();
        ResolveState initial = ResolveState.initial();
        for (GrImportStatement anImport : imports) {
            if (skipStaticImports == anImport.isStatic() || anImport.processDeclarations(processor, initial, null, place)) continue;
            return true;
        }
        return false;
    }

    private static void addAllClasses(CompletionParameters parameters, final CompletionResultSet result, InheritorsHolder inheritors) {
        GroovyCompletionContributor.addAllClasses(parameters, new Consumer<LookupElement>(){

            public void consume(LookupElement element) {
                result.addElement(element);
            }
        }, inheritors, result.getPrefixMatcher());
    }

    public static void addAllClasses(CompletionParameters parameters, final Consumer<LookupElement> consumer, final InheritorsHolder inheritors, PrefixMatcher matcher) {
        PsiElement position = parameters.getPosition();
        final boolean afterNew = JavaClassNameCompletionContributor.AFTER_NEW.accepts((Object)position);
        AllClassesGetter.processJavaClasses((CompletionParameters)parameters, (PrefixMatcher)matcher, (parameters.getInvocationCount() <= 1 ? 1 : 0) != 0, (Consumer)new Consumer<PsiClass>(){

            public void consume(PsiClass psiClass) {
                for (JavaPsiClassReferenceElement element : JavaClassNameCompletionContributor.createClassLookupItems((PsiClass)psiClass, (boolean)afterNew, (InsertHandler)new GroovyClassNameInsertHandler(), (Condition)new Condition<PsiClass>(){

                    public boolean value(PsiClass psiClass) {
                        return !inheritors.alreadyProcessed(psiClass);
                    }
                })) {
                    consumer.consume((Object)element);
                }
            }
        });
    }

    public GroovyCompletionContributor() {
        this.extend(CompletionType.BASIC, AFTER_DOT, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                String shortcut;
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionContributor$6", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionContributor$6", "addCompletions"));
                }
                PsiElement position = parameters.getPosition();
                assert (position.getParent() instanceof GrReferenceExpression);
                GrReferenceExpression refExpr = (GrReferenceExpression)position.getParent();
                GrExpression qualifier = refExpr.getQualifierExpression();
                if (!(qualifier instanceof GrReferenceExpression)) {
                    return;
                }
                GrReferenceExpression referenceExpression = (GrReferenceExpression)qualifier;
                PsiElement resolved = referenceExpression.resolve();
                if (!(resolved instanceof PsiClass)) {
                    return;
                }
                if (parameters.getInvocationCount() > 0 && CompletionUtil.shouldShowFeature((CompletionParameters)parameters, (String)"editing.completion.global.member.name") && (shortcut = GroovyCompletionContributor.getActionShortcut((String)"CodeCompletion")) != null) {
                    result.addLookupAdvertisement("Pressing " + shortcut + " twice without a class qualifier would show all accessible static methods");
                }
                if (!PsiUtil.hasEnclosingInstanceInScope((PsiClass)resolved, position, false)) {
                    return;
                }
                for (String keyword : THIS_SUPER) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)keyword));
                }
            }
        });
        MapArgumentCompletionProvider.register(this);
        GroovyConfigSlurperCompletionProvider.register(this);
        MapKeysCompletionProvider.register(this);
        GroovyDocCompletionProvider.register(this);
        this.extend(CompletionType.BASIC, (ElementPattern)STATEMENT_START, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionContributor$7", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionContributor$7", "addCompletions"));
                }
                result.addElement((LookupElement)LookupElementBuilder.create((String)"if").bold().withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                    public void handleInsert(InsertionContext context, LookupElement item) {
                        if (context.getCompletionChar() != ' ') {
                            TailTypes.IF_LPARENTH.processTail(context.getEditor(), context.getTailOffset());
                        }
                        if (context.getCompletionChar() == '(') {
                            context.setAddCompletionChar(false);
                        }
                    }
                }));
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement(PsiElement.class), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, final @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionContributor$8", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionContributor$8", "addCompletions"));
                }
                GroovyCompletionData.addGroovyDocKeywords(parameters, result);
                PsiElement position = parameters.getPosition();
                if (((PsiElementPattern.Capture)PlatformPatterns.psiElement().inside(false, (ElementPattern)PlatformPatterns.psiElement(PsiComment.class))).accepts((Object)position)) {
                    return;
                }
                GroovyCompletionData.addGroovyKeywords(parameters, result);
                GroovyCompletionContributor.addUnfinishedMethodTypeParameters(position, result);
                GroovyCompletionContributor.suggestVariableNames(position, result);
                GrReferenceElement reference = GroovyCompletionContributor.findGroovyReference(position);
                if (reference == null) {
                    if (parameters.getInvocationCount() >= 2) {
                        result.stopHere();
                        GroovyCompletionContributor.addAllClasses(parameters, result.withPrefixMatcher(CompletionUtil.findJavaIdentifierPrefix((CompletionParameters)parameters)), new InheritorsHolder(parameters.getPosition(), result));
                    }
                    return;
                }
                if (reference.getParent() instanceof GrImportStatement && reference.getQualifier() != null) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)"*"));
                }
                InheritorsHolder inheritors = new InheritorsHolder(position, result);
                if (GroovySmartCompletionContributor.AFTER_NEW.accepts((Object)position)) {
                    GroovySmartCompletionContributor.generateInheritorVariants(parameters, result.getPrefixMatcher(), (Consumer<LookupElement>)inheritors);
                }
                Runnable addSlowVariants = GroovyCompletionContributor.completeReference(parameters, reference, inheritors, result.getPrefixMatcher(), new Consumer<LookupElement>(){

                    public void consume(LookupElement lookupElement) {
                        result.addElement(lookupElement);
                    }
                });
                if (reference.getQualifier() == null) {
                    if (!GroovySmartCompletionContributor.AFTER_NEW.accepts((Object)position)) {
                        GroovySmartCompletionContributor.addExpectedClassMembers(parameters, result);
                    }
                    if (GroovyCompletionContributor.isClassNamePossible(position) && JavaCompletionContributor.mayStartClassName((CompletionResultSet)result)) {
                        result.stopHere();
                        if (parameters.getInvocationCount() >= 2) {
                            GroovyCompletionContributor.addAllClasses(parameters, result, inheritors);
                        } else {
                            JavaCompletionContributor.advertiseSecondCompletion((Project)position.getProject(), (CompletionResultSet)result);
                        }
                    }
                }
                addSlowVariants.run();
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(GrLiteral.class), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionContributor$9", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionContributor$9", "addCompletions"));
                }
                THashSet usedWords = new THashSet();
                for (CompletionResult element : result.runRemainingContributors(parameters, true)) {
                    usedWords.add(element.getLookupElement().getLookupString());
                }
                PsiReference reference = parameters.getPosition().getContainingFile().findReferenceAt(parameters.getOffset());
                if (reference == null || reference.isSoft()) {
                    WordCompletionContributor.addWordCompletionVariants((CompletionResultSet)result, (CompletionParameters)parameters, (Set)usedWords);
                }
            }
        });
    }

    @Nullable
    private static GrReferenceElement findGroovyReference(PsiElement position) {
        PsiElement parent = position.getParent();
        if (parent instanceof GrReferenceElement) {
            return (GrReferenceElement)parent;
        }
        if (GroovyCompletionContributor.couldContainReference(position)) {
            return GroovyPsiElementFactory.getInstance(position.getProject()).createReferenceElementFromText("Foo", position);
        }
        return null;
    }

    private static boolean couldContainReference(PsiElement position) {
        return IN_CATCH_TYPE.accepts((Object)position) || AFTER_AT.accepts((Object)position) || GroovyCompletionUtil.isFirstElementAfterPossibleModifiersInVariableDeclaration(position, true) || GroovyCompletionUtil.isTupleVarNameWithoutTypeDeclared(position);
    }

    public static boolean isClassNamePossible(PsiElement position) {
        PsiElement parent = position.getParent();
        if (parent instanceof GrReferenceElement) {
            return ((GrReferenceElement)parent).getQualifier() == null;
        }
        return GroovyCompletionContributor.couldContainReference(position);
    }

    public void fillCompletionVariants(CompletionParameters parameters, CompletionResultSet result) {
        if (AFTER_NUMBER_LITERAL.accepts((Object)parameters.getPosition())) {
            return;
        }
        super.fillCompletionVariants(parameters, result);
    }

    private static void addUnfinishedMethodTypeParameters(@NotNull PsiElement position, @NotNull CompletionResultSet result) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionContributor", "addUnfinishedMethodTypeParameters"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionContributor", "addUnfinishedMethodTypeParameters"));
        }
        GrTypeParameterList candidate = GroovyCompletionContributor.findTypeParameterListCandidate(position);
        if (candidate != null) {
            for (GrTypeParameter p : candidate.getTypeParameters()) {
                result.addElement((LookupElement)new JavaPsiClassReferenceElement((PsiClass)p));
            }
        }
    }

    @Nullable
    private static GrTypeParameterList findTypeParameterListCandidate(@NotNull PsiElement position) {
        PsiElement child;
        PsiElement errorElement;
        PsiElement pparent;
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionContributor", "findTypeParameterListCandidate"));
        }
        PsiElement parent = position.getParent();
        if (parent instanceof GrVariable && (pparent = parent.getParent()) instanceof GrVariableDeclaration && (errorElement = PsiUtil.skipWhitespacesAndComments(parent.getPrevSibling(), false)) instanceof PsiErrorElement && (child = errorElement.getFirstChild()) instanceof GrTypeParameterList) {
            return (GrTypeParameterList)child;
        }
        return null;
    }

    @NotNull
    static Runnable completeReference(CompletionParameters parameters, GrReferenceElement reference, final InheritorsHolder inheritorsHolder, PrefixMatcher matcher, final Consumer<LookupElement> _consumer) {
        PsiType qualifierType;
        Consumer<LookupElement> consumer = new Consumer<LookupElement>(){
            final Set<LookupElement> added = ContainerUtil.newHashSet();

            public void consume(LookupElement element) {
                if (this.added.add(element)) {
                    _consumer.consume((Object)element);
                }
            }
        };
        final HashMap staticMembers = ContainerUtil.newHashMap();
        PsiElement qualifier = reference.getQualifier();
        PsiType psiType = qualifierType = qualifier instanceof GrExpression ? ((GrExpression)qualifier).getType() : null;
        if (reference instanceof GrReferenceExpression && (qualifier instanceof GrExpression || qualifier == null)) {
            for (String string : CompleteReferenceExpression.getVariantsWithSameQualifier(matcher, (GrExpression)qualifier, (GrReferenceExpression)reference)) {
                consumer.consume((Object)LookupElementBuilder.create((String)string).withItemTextUnderlined(true));
            }
            if (!(parameters.getInvocationCount() >= 2 || qualifier == null || qualifierType != null || qualifier instanceof GrReferenceExpression && ((GrReferenceExpression)qualifier).resolve() instanceof PsiPackage)) {
                if (parameters.getInvocationCount() == 1) {
                    GroovyCompletionContributor.showInfo();
                }
                Runnable runnable = EmptyRunnable.INSTANCE;
                if (runnable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionContributor", "completeReference"));
                }
                return runnable;
            }
        }
        final ArrayList zeroPriority = ContainerUtil.newArrayList();
        reference.processVariants(matcher, parameters, new Consumer<LookupElement>((Consumer)consumer){
            final /* synthetic */ Consumer val$consumer;
            {
                this.val$consumer = consumer;
            }

            public void consume(LookupElement lookupElement) {
                PrioritizedLookupElement prio;
                Object object = lookupElement.getObject();
                if (object instanceof GroovyResolveResult) {
                    object = ((GroovyResolveResult)object).getElement();
                }
                if (GroovyCompletionContributor.isLightElementDeclaredDuringCompletion(object)) {
                    return;
                }
                if (!(lookupElement instanceof LookupElementBuilder) && inheritorsHolder.alreadyProcessed(lookupElement)) {
                    return;
                }
                if (object instanceof PsiMember && JavaCompletionUtil.isInExcludedPackage((PsiMember)((PsiMember)object), (boolean)true)) {
                    return;
                }
                if (!(object instanceof PsiClass)) {
                    int priority = GroovyCompletionContributor.assignPriority(lookupElement, qualifierType);
                    lookupElement = JavaCompletionUtil.highlightIfNeeded((PsiType)qualifierType, (LookupElement)PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)priority), (Object)object);
                }
                if ((object instanceof PsiMethod || object instanceof PsiField) && ((PsiModifierListOwner)object).hasModifierProperty("static") && lookupElement.getLookupString().equals(((PsiMember)object).getName())) {
                    staticMembers.put(CompletionUtil.getOriginalOrSelf((PsiElement)((PsiModifierListOwner)object)), lookupElement);
                }
                if ((prio = (PrioritizedLookupElement)lookupElement.as(PrioritizedLookupElement.CLASS_CONDITION_KEY)) == null || prio.getPriority() == 0.0) {
                    zeroPriority.add(lookupElement);
                } else {
                    this.val$consumer.consume((Object)lookupElement);
                }
            }
        });
        for (LookupElement element : zeroPriority) {
            consumer.consume((Object)element);
        }
        if (qualifier == null) {
            Runnable runnable = GroovyCompletionContributor.addStaticMembers(parameters, matcher, staticMembers, consumer);
            if (runnable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionContributor", "completeReference"));
            }
            return runnable;
        }
        Runnable runnable = EmptyRunnable.INSTANCE;
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionContributor", "completeReference"));
        }
        return runnable;
    }

    private static boolean isLightElementDeclaredDuringCompletion(Object object) {
        if (!(object instanceof LightElement) || !(object instanceof PsiNamedElement)) {
            return false;
        }
        String name = ((PsiNamedElement)object).getName();
        if (name == null) {
            return false;
        }
        return name.contains("IntellijIdeaRulezzz".trim()) || name.contains(DUMMY_IDENTIFIER_DECAPITALIZED.trim());
    }

    private static Runnable addStaticMembers(CompletionParameters parameters, final PrefixMatcher matcher, final Map<PsiModifierListOwner, LookupElement> staticMembers, final Consumer<LookupElement> consumer) {
        final StaticMemberProcessor processor = GroovyCompletionContributor.completeStaticMembers(parameters);
        processor.processMembersOfRegisteredClasses(matcher, (PairConsumer)new PairConsumer<PsiMember, PsiClass>(){

            public void consume(PsiMember member, PsiClass psiClass) {
                if (member instanceof GrAccessorMethod) {
                    member = ((GrAccessorMethod)member).getProperty();
                }
                if (staticMembers.containsKey(member = (PsiMember)CompletionUtil.getOriginalOrSelf((PsiElement)member))) {
                    return;
                }
                String name = member.getName();
                if (name == null || !matcher.prefixMatches(name)) {
                    staticMembers.remove(member);
                    return;
                }
                JavaGlobalMemberLookupElement element = GroovyCompletionContributor.createGlobalMemberElement(member, psiClass, true);
                staticMembers.put(member, element);
                consumer.consume((Object)element);
            }
        });
        if (parameters.getInvocationCount() >= 2 && StringUtil.isNotEmpty((String)matcher.getPrefix())) {
            return new Runnable(){

                @Override
                public void run() {
                    processor.processStaticMethodsGlobally(matcher, (Consumer)new Consumer<LookupElement>(){

                        public void consume(LookupElement element) {
                            PsiMember member = (PsiMember)element.getObject();
                            if (member instanceof GrAccessorMethod) {
                                member = ((GrAccessorMethod)member).getProperty();
                            }
                            if (staticMembers.containsKey(member = (PsiMember)CompletionUtil.getOriginalOrSelf((PsiElement)member))) {
                                return;
                            }
                            staticMembers.put(member, element);
                            consumer.consume((Object)element);
                        }
                    });
                }
            };
        }
        return EmptyRunnable.INSTANCE;
    }

    private static void showInfo() {
        CompletionService.getCompletionService().setAdvertisementText(GroovyBundle.message("invoke.completion.second.time.to.show.skipped.methods", new Object[0]));
    }

    private static boolean checkForIterator(PsiMethod method) {
        if (!"next".equals(method.getName())) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        PsiClass iterator = JavaPsiFacade.getInstance((Project)method.getProject()).findClass("java.util.Iterator", method.getResolveScope());
        return InheritanceUtil.isInheritorOrSelf((PsiClass)containingClass, (PsiClass)iterator, (boolean)true);
    }

    private static int assignPriority(LookupElement lookupElement, PsiType qualifierType) {
        Object object = lookupElement.getObject();
        PsiSubstitutor substitutor = null;
        GroovyResolveResult resolveResult = null;
        if (object instanceof GroovyResolveResult) {
            resolveResult = (GroovyResolveResult)object;
            substitutor = resolveResult.getSubstitutor();
            object = ((GroovyResolveResult)object).getElement();
        }
        if (object instanceof GrGdkMethod && GroovyCompletionUtil.skipDefGroovyMethod((GrGdkMethod)object, substitutor, qualifierType)) {
            return -1;
        }
        if (object instanceof PsiMethod && GroovyCompletionUtil.OPERATOR_METHOD_NAMES.contains(((PsiMethod)object).getName()) && !GroovyCompletionContributor.checkForIterator((PsiMethod)object)) {
            return -3;
        }
        if (object instanceof PsiMethod && GroovyPropertyUtils.isSimplePropertyAccessor((PsiMethod)object)) {
            return -1;
        }
        if (resolveResult != null && !resolveResult.isAccessible()) {
            return -2;
        }
        return 0;
    }

    static StaticMemberProcessor completeStaticMembers(CompletionParameters parameters) {
        PsiElement position = parameters.getPosition();
        final PsiElement originalPosition = parameters.getOriginalPosition();
        StaticMemberProcessor processor = new StaticMemberProcessor(position){

            @NotNull
            protected LookupElement createLookupElement(@NotNull PsiMember member, @NotNull PsiClass containingClass, boolean shouldImport) {
                if (member == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionContributor$14", "createLookupElement"));
                }
                if (containingClass == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionContributor$14", "createLookupElement"));
                }
                JavaGlobalMemberLookupElement javaGlobalMemberLookupElement = GroovyCompletionContributor.createGlobalMemberElement(member, containingClass, shouldImport |= originalPosition != null && PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)originalPosition, (boolean)false));
                if (javaGlobalMemberLookupElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionContributor$14", "createLookupElement"));
                }
                return javaGlobalMemberLookupElement;
            }

            protected LookupElement createLookupElement(@NotNull List<PsiMethod> overloads, @NotNull PsiClass containingClass, boolean shouldImport) {
                if (overloads == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionContributor$14", "createLookupElement"));
                }
                if (containingClass == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionContributor$14", "createLookupElement"));
                }
                return new JavaGlobalMemberLookupElement(overloads, containingClass, QUALIFIED_METHOD_INSERT_HANDLER, STATIC_IMPORT_INSERT_HANDLER, shouldImport |= originalPosition != null && PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)originalPosition, (boolean)false));
            }

            protected boolean isAccessible(PsiMember member) {
                boolean result = super.isAccessible(member);
                if (!result && member instanceof GrField) {
                    GrAccessorMethod[] getters = ((GrField)member).getGetters();
                    return getters.length > 0 && super.isAccessible((PsiMember)getters[0]);
                }
                return result;
            }
        };
        PsiFile file = position.getContainingFile();
        if (file instanceof GroovyFile) {
            for (GrImportStatement statement : ((GroovyFile)file).getImportStatements()) {
                PsiElement target;
                GrCodeReferenceElement importReference;
                if (!statement.isStatic() || (importReference = statement.getImportReference()) == null) continue;
                if (!statement.isOnDemand()) {
                    importReference = (GrCodeReferenceElement)importReference.getQualifier();
                }
                if (importReference == null || !((target = importReference.resolve()) instanceof PsiClass)) continue;
                processor.importMembersOf((PsiClass)target);
            }
        }
        return processor;
    }

    static JavaGlobalMemberLookupElement createGlobalMemberElement(PsiMember member, PsiClass containingClass, boolean shouldImport) {
        return new JavaGlobalMemberLookupElement(member, containingClass, QUALIFIED_METHOD_INSERT_HANDLER, STATIC_IMPORT_INSERT_HANDLER, shouldImport);
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        PsiElement position;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionContributor", "beforeCompletion"));
        }
        String identifier = GroovyCompletionContributor.getIdentifier(context);
        if (identifier != null) {
            context.setDummyIdentifier(identifier);
        }
        if ((position = context.getFile().findElementAt(context.getStartOffset())) != null && position.getNode().getElementType() == GroovyTokenTypes.mDOLLAR) {
            context.getOffsetMap().addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, context.getStartOffset());
        }
    }

    private static String getIdentifier(CompletionInitializationContext context) {
        if (context.getCompletionType() == CompletionType.BASIC && context.getFile() instanceof GroovyFile) {
            PsiElement position = context.getFile().findElementAt(context.getStartOffset());
            if (position != null && position.getParent() instanceof GrVariable && position == ((GrVariable)position.getParent()).getNameIdentifierGroovy() || position != null && position.getParent() instanceof GrAnnotationNameValuePair && position == ((GrAnnotationNameValuePair)position.getParent()).getNameIdentifierGroovy()) {
                return CompletionUtil.DUMMY_IDENTIFIER_TRIMMED;
            }
            if (GroovyCompletionContributor.isIdentifierBeforeLParenth(context)) {
                return GroovyCompletionContributor.setCorrectCase(context) + ";";
            }
            if (GroovyCompletionContributor.isInPossibleClosureParameter(position)) {
                return GroovyCompletionContributor.setCorrectCase(context) + "->";
            }
            if (GroovyCompletionContributor.isBeforeAssign(context)) {
                return CompletionUtil.DUMMY_IDENTIFIER_TRIMMED;
            }
            return GroovyCompletionContributor.setCorrectCase(context);
        }
        return null;
    }

    private static boolean isBeforeAssign(CompletionInitializationContext context) {
        HighlighterIterator iterator = ((EditorEx)context.getEditor()).getHighlighter().createIterator(context.getStartOffset());
        if (iterator.atEnd()) {
            return false;
        }
        if (iterator.getTokenType() == GroovyTokenTypes.mIDENT) {
            iterator.advance();
        }
        while (!iterator.atEnd() && TokenSets.WHITE_SPACES_OR_COMMENTS.contains(iterator.getTokenType())) {
            iterator.advance();
        }
        return !iterator.atEnd() && iterator.getTokenType() == GroovyTokenTypes.mASSIGN;
    }

    private static String setCorrectCase(CompletionInitializationContext context) {
        PsiElement element = context.getFile().findElementAt(context.getStartOffset());
        if (element == null) {
            return DUMMY_IDENTIFIER_DECAPITALIZED;
        }
        String text = element.getText();
        if (text.length() == 0) {
            return DUMMY_IDENTIFIER_DECAPITALIZED;
        }
        return Character.isUpperCase(text.charAt(0)) ? "IntellijIdeaRulezzz " : DUMMY_IDENTIFIER_DECAPITALIZED;
    }

    public static boolean isInPossibleClosureParameter(PsiElement position) {
        if (position == null) {
            return false;
        }
        if (position instanceof PsiWhiteSpace || position.getNode().getElementType() == GroovyTokenTypes.mNLS) {
            position = FilterPositionUtil.searchNonSpaceNonCommentBack((PsiElement)position);
        }
        boolean hasCommas = false;
        while (position != null) {
            PsiElement parent = position.getParent();
            if (parent instanceof GrVariable) {
                PsiElement prev = FilterPositionUtil.searchNonSpaceNonCommentBack((PsiElement)parent);
                boolean bl = hasCommas = prev != null && prev.getNode().getElementType() == GroovyTokenTypes.mCOMMA;
            }
            if (parent instanceof GrClosableBlock) {
                for (PsiElement sibling = position.getPrevSibling(); sibling != null; sibling = sibling.getPrevSibling()) {
                    if (sibling instanceof GrParameterList) {
                        return hasCommas;
                    }
                    boolean isComma = sibling instanceof LeafPsiElement && GroovyTokenTypes.mCOMMA == ((LeafPsiElement)sibling).getElementType();
                    hasCommas |= isComma;
                    if (isComma || sibling instanceof PsiWhiteSpace || sibling instanceof PsiErrorElement || sibling instanceof GrVariableDeclaration || sibling instanceof GrReferenceExpression && !((GrReferenceExpression)sibling).isQualified()) {
                        continue;
                    }
                    return false;
                }
                return false;
            }
            position = parent;
        }
        return false;
    }

    private static boolean isIdentifierBeforeLParenth(CompletionInitializationContext context) {
        HighlighterIterator iterator = ((EditorEx)context.getEditor()).getHighlighter().createIterator(context.getStartOffset());
        if (iterator.atEnd()) {
            return false;
        }
        if (iterator.getTokenType() == GroovyTokenTypes.mIDENT) {
            iterator.advance();
        }
        while (!iterator.atEnd() && TokenSets.WHITE_SPACES_OR_COMMENTS.contains(iterator.getTokenType())) {
            iterator.advance();
        }
        return !iterator.atEnd() && iterator.getTokenType() == GroovyTokenTypes.mLPAREN;
    }

    public static void suggestVariableNames(PsiElement context, CompletionResultSet result) {
        GrVariable variable;
        PsiElement parent = context.getParent();
        if (GroovyCompletionUtil.isWildcardCompletion(context)) {
            return;
        }
        if (parent instanceof GrVariable && context.equals((variable = (GrVariable)parent).getNameIdentifierGroovy())) {
            GrExpression initializer;
            PsiType type = variable.getTypeGroovy();
            if (type != null) {
                String newName;
                String name;
                JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)context.getProject());
                VariableKind kind = variable instanceof GrParameter ? VariableKind.PARAMETER : (variable instanceof GrField ? VariableKind.FIELD : VariableKind.LOCAL_VARIABLE);
                SuggestedNameInfo suggestedNameInfo = codeStyleManager.suggestVariableName(kind, null, null, type);
                String[] names = suggestedNameInfo.names;
                if (names.length > 0 && !(name = names[0]).equals(newName = InlineMethodConflictSolver.suggestNewName(name, null, parent, new String[0]))) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)newName));
                    return;
                }
                for (String name2 : names) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)name2));
                }
            }
            if ((initializer = variable.getInitializerGroovy()) != null) {
                for (String name : GroovyNameSuggestionUtil.suggestVariableNames(initializer, new DefaultGroovyVariableNameValidator(variable), variable.hasModifierProperty("static"))) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)name));
                }
            }
        }
    }
}

