/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class RemoveRedundantClassPropertyIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/intentions/style/RemoveRedundantClassPropertyIntention", "processIntention"));
        }
        if (element instanceof GrReferenceExpression) {
            ((GrReferenceExpression)element).replaceWithExpression((GrExpression)((GrReferenceExpression)element).getQualifier(), true);
        }
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                GrExpression qualifier;
                if (element instanceof GrReferenceExpression && "class".equals(((GrReferenceExpression)element).getReferenceName()) && (qualifier = (GrExpression)((GrReferenceExpression)element).getQualifier()) instanceof GrReferenceExpression) {
                    return ((GrReferenceExpression)qualifier).resolve() instanceof PsiClass;
                }
                return false;
            }
        };
        if (psiElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/style/RemoveRedundantClassPropertyIntention", "getElementPredicate"));
        }
        return psiElementPredicate;
    }
}

