/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.other;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class GrCreateMissingSwitchBranchesIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/intentions/other/GrCreateMissingSwitchBranchesIntention", "processIntention"));
        }
        if (!(element instanceof GrSwitchStatement)) {
            return;
        }
        List<PsiEnumConstant> constants = GrCreateMissingSwitchBranchesIntention.findUnusedConstants((GrSwitchStatement)element);
        if (constants.isEmpty()) {
            return;
        }
        PsiEnumConstant first = constants.get(0);
        PsiClass aClass = first.getContainingClass();
        if (aClass == null) {
            return;
        }
        String qName = aClass.getQualifiedName();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        PsiElement anchor = GrCreateMissingSwitchBranchesIntention.findAnchor(element);
        for (PsiEnumConstant constant : constants) {
            GrCaseSection section = factory.createSwitchSection("case " + qName + "." + constant.getName() + ":\n break");
            PsiElement added = element.addBefore((PsiElement)section, anchor);
            element.addBefore(factory.createLineTerminator(1), anchor);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(added);
        }
    }

    @Nullable
    private static PsiElement findAnchor(PsiElement element) {
        PsiElement last = element.getLastChild();
        if (last != null && last.getNode().getElementType() == GroovyTokenTypes.mRCURLY) {
            return last;
        }
        return null;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                if (!(element instanceof GrSwitchStatement)) {
                    return false;
                }
                List unused = GrCreateMissingSwitchBranchesIntention.findUnusedConstants((GrSwitchStatement)element);
                return !unused.isEmpty();
            }
        };
        if (psiElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/other/GrCreateMissingSwitchBranchesIntention", "getElementPredicate"));
        }
        return psiElementPredicate;
    }

    private static List<PsiEnumConstant> findUnusedConstants(GrSwitchStatement switchStatement) {
        GrCaseSection[] sections;
        GrExpression condition = switchStatement.getCondition();
        if (condition == null) {
            return Collections.emptyList();
        }
        PsiType type = condition.getType();
        if (!(type instanceof PsiClassType)) {
            return Collections.emptyList();
        }
        PsiClass resolved = ((PsiClassType)type).resolve();
        if (resolved == null || !resolved.isEnum()) {
            return Collections.emptyList();
        }
        Object[] fields = resolved.getFields();
        List constants = ContainerUtil.findAll((Object[])fields, PsiEnumConstant.class);
        for (GrCaseSection section : sections = switchStatement.getCaseSections()) {
            for (GrCaseLabel label : section.getCaseLabels()) {
                GrExpression value = label.getValue();
                if (!(value instanceof GrReferenceExpression)) continue;
                PsiElement r = ((GrReferenceExpression)value).resolve();
                constants.remove(r);
            }
        }
        return constants;
    }
}

