/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;

public class GrConvertTypeCastToSafeCastIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/intentions/conversions/GrConvertTypeCastToSafeCastIntention", "processIntention"));
        }
        if (!(element instanceof GrTypeCastExpression)) {
            return;
        }
        GrExpression operand = ((GrTypeCastExpression)element).getOperand();
        GrTypeElement type = ((GrTypeCastExpression)element).getCastTypeElement();
        if (type == null) {
            return;
        }
        if (operand == null) {
            return;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        GrExpression safeCast = factory.createExpressionFromText(operand.getText() + " as " + type.getText());
        ((GrTypeCastExpression)element).replaceWithExpression(safeCast, true);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                return element instanceof GrTypeCastExpression && ((GrTypeCastExpression)element).getCastTypeElement() != null && ((GrTypeCastExpression)element).getOperand() != null;
            }
        };
        if (psiElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/conversions/GrConvertTypeCastToSafeCastIntention", "getElementPredicate"));
        }
        return psiElementPredicate;
    }
}

