/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.comments;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.comments.EndOfLineCommentPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;

public class ChangeToCStyleCommentIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        EndOfLineCommentPredicate endOfLineCommentPredicate = new EndOfLineCommentPredicate();
        if (endOfLineCommentPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/comments/ChangeToCStyleCommentIntention", "getElementPredicate"));
        }
        return endOfLineCommentPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        PsiElement prevComment;
        PsiComment selectedComment;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/intentions/comments/ChangeToCStyleCommentIntention", "processIntention"));
        }
        PsiComment firstComment = selectedComment = (PsiComment)element;
        while (this.isEndOfLineComment(prevComment = this.getPrevNonWhiteSpace((PsiElement)firstComment))) {
            firstComment = (PsiComment)prevComment;
        }
        JavaPsiFacade manager = JavaPsiFacade.getInstance((Project)selectedComment.getProject());
        PsiElementFactory factory = manager.getElementFactory();
        String text = ChangeToCStyleCommentIntention.getCommentContents(firstComment);
        ArrayList<PsiComment> commentsToDelete = new ArrayList<PsiComment>();
        PsiComment nextComment = firstComment;
        while (this.isEndOfLineComment((PsiElement)(nextComment = this.getNextNonWhiteSpace((PsiElement)nextComment)))) {
            text = text + nextComment.getPrevSibling().getText() + "  " + ChangeToCStyleCommentIntention.getCommentContents(nextComment);
            commentsToDelete.add(nextComment);
        }
        PsiComment newComment = factory.createCommentFromText("/*" + text + " */", selectedComment.getParent());
        firstComment.replace((PsiElement)newComment);
        for (PsiElement psiElement : commentsToDelete) {
            psiElement.delete();
        }
    }

    @Nullable
    private PsiElement getNextNonWhiteSpace(PsiElement nextComment) {
        PsiElement sibling;
        PsiElement elementToCheck = nextComment;
        while (true) {
            if ((sibling = elementToCheck.getNextSibling()) == null) {
                return null;
            }
            if (sibling.getText().trim().replace("\n", "").length() != 0) break;
            elementToCheck = sibling;
        }
        return sibling;
    }

    @Nullable
    private PsiElement getPrevNonWhiteSpace(PsiElement nextComment) {
        PsiElement sibling;
        PsiElement elementToCheck = nextComment;
        while (true) {
            if ((sibling = elementToCheck.getPrevSibling()) == null) {
                return null;
            }
            if (sibling.getText().trim().replace("\n", "").length() != 0) break;
            elementToCheck = sibling;
        }
        return sibling;
    }

    private boolean isEndOfLineComment(PsiElement element) {
        if (!(element instanceof PsiComment)) {
            return false;
        }
        PsiComment comment = (PsiComment)element;
        IElementType tokenType = comment.getTokenType();
        return GroovyTokenTypes.mSL_COMMENT.equals(tokenType);
    }

    private static String getCommentContents(PsiComment comment) {
        String text = comment.getText();
        return text.substring(2);
    }
}

