/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.base;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodFromUsageFix;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.annotator.intentions.QuickfixUtil;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.template.expressions.ChooseTypeExpression;
import org.jetbrains.plugins.groovy.template.expressions.ParameterNameExpression;

public class IntentionUtils {
    private static final Logger LOG = Logger.getInstance(IntentionUtils.class);

    public static void replaceExpression(@NotNull String newExpression, @NotNull GrExpression expression) throws IncorrectOperationException {
        if (newExpression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/intentions/base/IntentionUtils", "replaceExpression"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/intentions/base/IntentionUtils", "replaceExpression"));
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(expression.getProject());
        GrExpression newCall = factory.createExpressionFromText(newExpression);
        expression.replaceWithExpression(newCall, true);
    }

    public static GrStatement replaceStatement(@NonNls @NotNull String newStatement, @NonNls @NotNull GrStatement statement) throws IncorrectOperationException {
        if (newStatement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/intentions/base/IntentionUtils", "replaceStatement"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/intentions/base/IntentionUtils", "replaceStatement"));
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(statement.getProject());
        GrStatement newCall = (GrStatement)factory.createTopElementFromText(newStatement);
        return statement.replaceWithStatement(newCall);
    }

    public static void createTemplateForMethod(PsiType[] argTypes, ChooseTypeExpression[] paramTypesExpressions, PsiMethod method, PsiClass owner, TypeConstraint[] constraints, boolean isConstructor, final @NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "org/jetbrains/plugins/groovy/intentions/base/IntentionUtils", "createTemplateForMethod"));
        }
        final Project project = owner.getProject();
        PsiTypeElement typeElement = method.getReturnTypeElement();
        ChooseTypeExpression expr = new ChooseTypeExpression(constraints, PsiManager.getInstance((Project)project), context.getResolveScope(), method.getLanguage() == GroovyFileType.GROOVY_LANGUAGE);
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)method);
        if (!isConstructor) {
            assert (typeElement != null);
            builder.replaceElement((PsiElement)typeElement, (Expression)expr);
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        assert (parameters.length == argTypes.length);
        for (int i = 0; i < parameters.length; ++i) {
            PsiParameter parameter = parameters[i];
            PsiTypeElement parameterTypeElement = parameter.getTypeElement();
            builder.replaceElement((PsiElement)parameterTypeElement, (Expression)paramTypesExpressions[i]);
            builder.replaceElement((PsiElement)parameter.getNameIdentifier(), (Expression)new ParameterNameExpression(null));
        }
        PsiCodeBlock body = method.getBody();
        if (body != null) {
            PsiJavaToken lbrace = body.getLBrace();
            assert (lbrace != null);
            builder.setEndVariableAfter((PsiElement)lbrace);
        } else {
            builder.setEndVariableAfter((PsiElement)method.getParameterList());
        }
        method = (PsiMethod)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)method);
        Template template = builder.buildTemplate();
        final PsiFile targetFile = owner.getContainingFile();
        final Editor newEditor = QuickfixUtil.positionCursor(project, targetFile, (PsiElement)method);
        TextRange range = method.getTextRange();
        newEditor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
        TemplateManager manager = TemplateManager.getInstance((Project)project);
        TemplateEditingAdapter templateListener = new TemplateEditingAdapter(){

            public void templateFinished(Template template, boolean brokenOff) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        PsiTypeParameter[] typeParameters;
                        PsiDocumentManager.getInstance((Project)project).commitDocument(newEditor.getDocument());
                        int offset = newEditor.getCaretModel().getOffset();
                        PsiMethod method = (PsiMethod)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)targetFile, (int)(offset - 1), PsiMethod.class, (boolean)false);
                        if (context instanceof PsiMethod && (typeParameters = ((PsiMethod)context).getTypeParameters()).length > 0) {
                            for (PsiTypeParameter typeParameter : typeParameters) {
                                if (!CreateMethodFromUsageFix.checkTypeParam((PsiMethod)method, (PsiTypeParameter)typeParameter)) continue;
                                JVMElementFactory factory = JVMElementFactories.getFactory((Language)method.getLanguage(), (Project)method.getProject());
                                PsiTypeParameterList list = method.getTypeParameterList();
                                if (list == null) {
                                    PsiTypeParameterList newList = factory.createTypeParameterList();
                                    list = (PsiTypeParameterList)method.addAfter((PsiElement)newList, (PsiElement)method.getModifierList());
                                }
                                list.add((PsiElement)factory.createTypeParameter(typeParameter.getName(), typeParameter.getExtendsList().getReferencedTypes()));
                            }
                        }
                        if (method != null) {
                            try {
                                boolean hasNoReturnType;
                                boolean bl = hasNoReturnType = method.getReturnTypeElement() == null && method instanceof GrMethod;
                                if (hasNoReturnType) {
                                    ((GrMethod)method).setReturnType((PsiType)PsiType.VOID);
                                }
                                if (method.getBody() != null) {
                                    FileTemplateManager templateManager = FileTemplateManager.getInstance();
                                    FileTemplate fileTemplate = templateManager.getCodeTemplate("Groovy New Method Body.groovy");
                                    CreateFromUsageUtils.setupMethodBody((PsiMethod)method, (PsiClass)method.getContainingClass(), (FileTemplate)fileTemplate);
                                }
                                if (hasNoReturnType) {
                                    ((GrMethod)method).setReturnType(null);
                                }
                            }
                            catch (IncorrectOperationException e) {
                                LOG.error((Throwable)e);
                            }
                            CreateFromUsageUtils.setupEditor((PsiMethod)method, (Editor)newEditor);
                        }
                    }
                });
            }
        };
        manager.startTemplate(newEditor, template, (TemplateEditingListener)templateListener);
    }
}

