/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gpp;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.dsl.toplevel.AnnotatedContextFilter;
import org.jetbrains.plugins.groovy.findUsages.LiteralConstructorReference;
import org.jetbrains.plugins.groovy.gpp.GppClosureParameterTypeProvider;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;

public class GppTypeConverter
extends GrTypeConverter {
    public static final String GROOVY_LANG_TYPED = "groovy.lang.Typed";

    public static boolean hasTypedContext(@Nullable PsiElement context) {
        if (context == null) {
            return false;
        }
        if (AnnotatedContextFilter.findContextAnnotation(context, GROOVY_LANG_TYPED) != null) {
            return true;
        }
        return GppTypeConverter.isGppExtension(StringUtil.getShortName((String)context.getContainingFile().getName()));
    }

    public static boolean isGppExtension(String extension) {
        return "gpp".equals(extension) || "grunit".equals(extension);
    }

    @Override
    public boolean isAllowedInMethodCall() {
        return true;
    }

    @Override
    public Boolean isConvertible(@NotNull PsiType lType, @NotNull PsiType rType, @NotNull GroovyPsiElement context) {
        PsiType[] methodParameters;
        if (lType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/gpp/GppTypeConverter", "isConvertible"));
        }
        if (rType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/gpp/GppTypeConverter", "isConvertible"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/gpp/GppTypeConverter", "isConvertible"));
        }
        if (context instanceof GrListOrMap && context.getReference() instanceof LiteralConstructorReference && ((LiteralConstructorReference)context.getReference()).getConstructedClassType() != null) {
            return null;
        }
        if (rType instanceof GrTupleType) {
            PsiType tupleComponent;
            PsiType[] parameters;
            GrTupleType tupleType = (GrTupleType)rType;
            PsiType expectedComponent = PsiUtil.extractIterableTypeParameter((PsiType)lType, (boolean)false);
            if (expectedComponent != null && GppTypeConverter.isMethodCallConversion(context) && (parameters = tupleType.getParameters()).length == 1 && (tupleComponent = parameters[0]) != null && TypesUtil.isAssignable(expectedComponent, tupleComponent, context) && GppTypeConverter.hasDefaultConstructor(lType)) {
                return true;
            }
            if (lType instanceof PsiClassType && GppTypeConverter.hasTypedContext(context)) {
                return true;
            }
        } else if (rType instanceof GrMapType) {
            PsiType lKeyType = PsiUtil.substituteTypeParameter((PsiType)lType, (String)"java.util.Map", (int)0, (boolean)false);
            PsiType lValueType = PsiUtil.substituteTypeParameter((PsiType)lType, (String)"java.util.Map", (int)1, (boolean)false);
            PsiType[] parameters = ((GrMapType)rType).getParameters();
            if (!(parameters.length != 2 || lKeyType == null || lValueType == null || parameters[0] == null || parameters[1] == null || TypesUtil.isAssignable(lKeyType, parameters[0], context) && TypesUtil.isAssignable(lValueType, parameters[1], context))) {
                return null;
            }
            if (GppTypeConverter.hasTypedContext(context)) {
                return true;
            }
        } else if (rType instanceof GrClosureType && GppTypeConverter.hasTypedContext(context) && GppTypeConverter.isClosureOverride(methodParameters = GppClosureParameterTypeProvider.findSingleAbstractMethodSignature(lType), (GrClosureType)rType, context)) {
            return true;
        }
        return null;
    }

    public static boolean isClosureOverride(PsiType[] methodParameters, GrClosureType closureType, GroovyPsiElement context) {
        GrSignature signature = closureType.getSignature();
        return methodParameters != null && GrClosureSignatureUtil.isSignatureApplicable(signature, methodParameters, context);
    }

    public static boolean hasDefaultConstructor(PsiType type) {
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type);
        return psiClass != null && PsiUtil.hasDefaultConstructor((PsiClass)psiClass, (boolean)true, (boolean)false);
    }
}

