/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gant;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import icons.JetgroovyIcons;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.config.GroovyLibraryPresentationProviderBase;
import org.jetbrains.plugins.groovy.gant.GantUtils;

public class GantLibraryPresentationProvider
extends GroovyLibraryPresentationProviderBase {
    private static final LibraryKind GANT_KIND = LibraryKind.create((String)"gant");

    public GantLibraryPresentationProvider() {
        super(GANT_KIND);
    }

    @Override
    public boolean managesLibrary(VirtualFile[] libraryFiles) {
        return GantUtils.isGantLibrary(libraryFiles);
    }

    @Override
    @Nls
    public String getLibraryVersion(VirtualFile[] libraryFiles) {
        return GantUtils.getGantVersion(GantUtils.getGantLibraryHome(libraryFiles));
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = JetgroovyIcons.Groovy.Gant_sdk;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/gant/GantLibraryPresentationProvider", "getIcon"));
        }
        return icon;
    }

    @Override
    public boolean isSDKHome(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/gant/GantLibraryPresentationProvider", "isSDKHome"));
        }
        return GantUtils.isGantSdkHome(file);
    }

    @Override
    @NotNull
    public String getSDKVersion(String path) {
        String string = GantUtils.getGantVersion(path);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/gant/GantLibraryPresentationProvider", "getSDKVersion"));
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getLibraryCategoryName() {
        if ("Gant" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/gant/GantLibraryPresentationProvider", "getLibraryCategoryName"));
        }
        return "Gant";
    }

    @Override
    protected void fillLibrary(String path, LibraryEditor libraryEditor) {
        File lib;
        File[] jars;
        File srcRoot = new File(path + "/src/main");
        if (srcRoot.exists()) {
            libraryEditor.addRoot(VfsUtil.getUrlForLibraryRoot((File)srcRoot), OrderRootType.SOURCES);
        }
        File[] fileArray = jars = (lib = new File(path + "/lib")).exists() ? lib.listFiles() : new File[]{};
        if (jars != null) {
            for (File file : jars) {
                if (!file.getName().endsWith(".jar")) continue;
                libraryEditor.addRoot(VfsUtil.getUrlForLibraryRoot((File)file), OrderRootType.CLASSES);
            }
        }
    }
}

