/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter.blocks;

import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiErrorElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.formatter.AlignmentProvider;
import org.jetbrains.plugins.groovy.formatter.FormattingContext;
import org.jetbrains.plugins.groovy.formatter.blocks.GroovyBlock;
import org.jetbrains.plugins.groovy.formatter.blocks.GroovyBlockGenerator;
import org.jetbrains.plugins.groovy.formatter.processors.GroovyWrappingProcessor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class ParameterListBlock
extends GroovyBlock {
    private final List<Block> mySubBlocks;
    private final TextRange myTextRange;

    @Override
    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/formatter/blocks/ParameterListBlock", "getTextRange"));
        }
        return textRange;
    }

    public ParameterListBlock(@NotNull GrMethod method, @NotNull Indent indent, @Nullable Wrap wrap, @NotNull FormattingContext context) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/formatter/blocks/ParameterListBlock", "<init>"));
        }
        if (indent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/formatter/blocks/ParameterListBlock", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/groovy/formatter/blocks/ParameterListBlock", "<init>"));
        }
        super(method.getParameterList().getNode(), indent, wrap, context);
        ASTNode methodNode = method.getNode();
        ASTNode leftParenth = methodNode.findChildByType(mLPAREN);
        ASTNode rightParenth = methodNode.findChildByType(mRPAREN);
        GroovyWrappingProcessor wrappingProcessor = new GroovyWrappingProcessor(this);
        this.mySubBlocks = new ArrayList<Block>();
        if (leftParenth != null) {
            this.mySubBlocks.add(new GroovyBlock(leftParenth, Indent.getNoneIndent(), Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), this.myContext));
        }
        List<ASTNode> astNodes = GroovyBlockGenerator.visibleChildren(this.myNode);
        boolean unfinished = ParameterListBlock.isParameterListUnfinished(this.myNode);
        if (this.myContext.getSettings().ALIGN_MULTILINE_PARAMETERS) {
            AlignmentProvider.Aligner aligner = this.myContext.getAlignmentProvider().createAligner(false);
            for (ASTNode node : astNodes) {
                aligner.append(node.getPsi());
            }
            if (rightParenth != null && unfinished) {
                aligner.append(rightParenth.getPsi());
            }
        }
        for (ASTNode childNode : astNodes) {
            this.mySubBlocks.add(new GroovyBlock(childNode, Indent.getContinuationIndent(), wrappingProcessor.getChildWrap(childNode), this.myContext));
        }
        if (rightParenth != null) {
            this.mySubBlocks.add(new GroovyBlock(rightParenth, unfinished ? Indent.getContinuationIndent() : Indent.getNoneIndent(), Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), this.myContext));
            if (!unfinished && this.myContext.getSettings().ALIGN_MULTILINE_METHOD_BRACKETS && leftParenth != null) {
                this.myContext.getAlignmentProvider().addPair(leftParenth, rightParenth, false);
            }
        }
        this.myTextRange = TextRange.create((int)this.mySubBlocks.get(0).getTextRange().getStartOffset(), (int)this.mySubBlocks.get(this.mySubBlocks.size() - 1).getTextRange().getEndOffset());
    }

    @Override
    @NotNull
    public List<Block> getSubBlocks() {
        List<Block> list = this.mySubBlocks;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/formatter/blocks/ParameterListBlock", "getSubBlocks"));
        }
        return list;
    }

    private static boolean isParameterListUnfinished(ASTNode parameterList) {
        ASTNode last = parameterList.getLastChildNode();
        return last instanceof PsiErrorElement;
    }
}

