/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.findUsages.GrHighlightExitPointHandler;
import org.jetbrains.plugins.groovy.findUsages.GrHighlightOverridingMethodsHandler;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public class GrHighlightHandlerFactory
implements HighlightUsagesHandlerFactory {
    public HighlightUsagesHandlerBase createHighlightUsagesHandler(Editor editor, PsiFile file) {
        int offset = TargetElementUtilBase.adjustOffset((PsiFile)file, (Document)editor.getDocument(), (int)editor.getCaretModel().getOffset());
        PsiElement target = file.findElementAt(offset);
        if (target == null) {
            return null;
        }
        ASTNode node = target.getNode();
        if (node == null) {
            return null;
        }
        IElementType type = node.getElementType();
        if (type == GroovyTokenTypes.kIMPLEMENTS || type == GroovyTokenTypes.kEXTENDS) {
            PsiElement parent = target.getParent();
            if (!(parent instanceof GrReferenceList)) {
                return null;
            }
            PsiElement grand = parent.getParent();
            if (!(grand instanceof GrTypeDefinition)) {
                return null;
            }
            return new GrHighlightOverridingMethodsHandler(editor, file, target, (GrTypeDefinition)grand);
        }
        if (type == GroovyTokenTypes.kRETURN || type == GroovyTokenTypes.kTHROW) {
            return new GrHighlightExitPointHandler(editor, file, target);
        }
        return null;
    }
}

