/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.extensions;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class NamedArgumentDescriptor {
    public static final NamedArgumentDescriptor SIMPLE_ON_TOP = new UnmodifiableDescriptor(Priority.ALWAYS_ON_TOP);
    public static final NamedArgumentDescriptor SIMPLE_AS_LOCAL_VAR = new UnmodifiableDescriptor(Priority.AS_LOCAL_VARIABLE);
    public static final NamedArgumentDescriptor SIMPLE_NORMAL = new UnmodifiableDescriptor(Priority.NORMAL);
    public static final NamedArgumentDescriptor SIMPLE_UNLIKELY = new UnmodifiableDescriptor(Priority.UNLIKELY);
    public static final StringTypeConditionWithPriority TYPE_STRING = new StringTypeConditionWithPriority("java.lang.String");
    public static final StringTypeConditionWithPriority TYPE_CLOSURE = new StringTypeConditionWithPriority("groovy.lang.Closure");
    public static final StringTypeConditionWithPriority TYPE_MAP = new StringTypeConditionWithPriority("java.util.Map");
    public static final StringTypeConditionWithPriority TYPE_LIST = new StringTypeConditionWithPriority("java.util.List");
    public static final StringTypeConditionWithPriority TYPE_BOOL = new StringTypeConditionWithPriority("java.lang.Boolean");
    public static final StringTypeConditionWithPriority TYPE_CLASS = new StringTypeConditionWithPriority("java.lang.Class");
    public static final StringTypeConditionWithPriority TYPE_INTEGER = new StringTypeConditionWithPriority("java.lang.Integer");
    private final PsiElement myNavigationElement;
    private final PsiSubstitutor mySubstitutor;
    private Priority myPriority = Priority.ALWAYS_ON_TOP;

    public NamedArgumentDescriptor() {
        this(null);
    }

    public NamedArgumentDescriptor(@Nullable PsiElement navigationElement) {
        this(navigationElement, PsiSubstitutor.EMPTY);
    }

    public NamedArgumentDescriptor(@Nullable PsiElement navigationElement, PsiSubstitutor substitutor) {
        this.myNavigationElement = navigationElement;
        this.mySubstitutor = substitutor;
    }

    @NotNull
    public Priority getPriority() {
        Priority priority = this.myPriority;
        if (priority == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/extensions/NamedArgumentDescriptor", "getPriority"));
        }
        return priority;
    }

    public NamedArgumentDescriptor setPriority(@NotNull Priority priority) {
        if (priority == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/extensions/NamedArgumentDescriptor", "setPriority"));
        }
        this.myPriority = priority;
        return this;
    }

    public boolean checkType(@NotNull PsiType type, @NotNull GroovyPsiElement context) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/extensions/NamedArgumentDescriptor", "checkType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/extensions/NamedArgumentDescriptor", "checkType"));
        }
        return true;
    }

    @Nullable
    public PsiPolyVariantReference createReference(@NotNull GrArgumentLabel element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/extensions/NamedArgumentDescriptor", "createReference"));
        }
        PsiElement navigationElement = this.getNavigationElement();
        if (navigationElement == null) {
            return null;
        }
        return new NamedArgumentReference(element, navigationElement, this.mySubstitutor);
    }

    @Nullable
    public PsiElement getNavigationElement() {
        return this.myNavigationElement;
    }

    private static class UnmodifiableDescriptor
    extends NamedArgumentDescriptor {
        public UnmodifiableDescriptor(Priority priority) {
            super.setPriority(priority);
        }

        @Override
        public NamedArgumentDescriptor setPriority(@NotNull Priority priority) {
            if (priority == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/extensions/NamedArgumentDescriptor$UnmodifiableDescriptor", "setPriority"));
            }
            throw new UnsupportedOperationException();
        }
    }

    public static class TypeCondition
    extends NamedArgumentDescriptor {
        private final PsiType myType;

        public TypeCondition(@NotNull PsiType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/extensions/NamedArgumentDescriptor$TypeCondition", "<init>"));
            }
            this(type, null, PsiSubstitutor.EMPTY);
        }

        public TypeCondition(@NotNull PsiType type, @Nullable PsiElement navigationElement) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/extensions/NamedArgumentDescriptor$TypeCondition", "<init>"));
            }
            this(type, navigationElement, PsiSubstitutor.EMPTY);
        }

        public TypeCondition(PsiType type, PsiElement navigationElement, PsiSubstitutor substitutor) {
            super(navigationElement, substitutor);
            this.myType = type;
        }

        @Override
        public boolean checkType(@NotNull PsiType type, @NotNull GroovyPsiElement context) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/extensions/NamedArgumentDescriptor$TypeCondition", "checkType"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/extensions/NamedArgumentDescriptor$TypeCondition", "checkType"));
            }
            return TypesUtil.isAssignable(this.myType, type, context);
        }
    }

    public static class StringArrayTypeCondition
    extends NamedArgumentDescriptor {
        private final String[] myTypeNames;

        public StringArrayTypeCondition(String ... typeNames) {
            this((PsiElement)null, typeNames);
        }

        public StringArrayTypeCondition(@Nullable PsiElement navigationElement, String ... typeNames) {
            super(navigationElement);
            this.myTypeNames = typeNames;
        }

        @Override
        public boolean checkType(@NotNull PsiType type, @NotNull GroovyPsiElement context) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/extensions/NamedArgumentDescriptor$StringArrayTypeCondition", "checkType"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/extensions/NamedArgumentDescriptor$StringArrayTypeCondition", "checkType"));
            }
            for (String typeName : this.myTypeNames) {
                if (!GroovyPsiManager.isInheritorCached(type, typeName)) continue;
                return true;
            }
            return false;
        }
    }

    public static class StringTypeCondition
    extends NamedArgumentDescriptor {
        protected final String myTypeName;

        public StringTypeCondition(String typeName) {
            this(typeName, null);
        }

        public StringTypeCondition(String typeName, @Nullable PsiElement navigationElement) {
            super(navigationElement);
            this.myTypeName = typeName;
        }

        @Override
        public boolean checkType(@NotNull PsiType type, @NotNull GroovyPsiElement context) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/extensions/NamedArgumentDescriptor$StringTypeCondition", "checkType"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/extensions/NamedArgumentDescriptor$StringTypeCondition", "checkType"));
            }
            return GroovyPsiManager.isInheritorCached(type, this.myTypeName);
        }
    }

    private static class StringTypeConditionWithPriority
    extends StringTypeCondition {
        private StringTypeConditionWithPriority[] myInstances;

        public StringTypeConditionWithPriority(String typeName) {
            this(typeName, Priority.ALWAYS_ON_TOP, new StringTypeConditionWithPriority[Priority.values().length]);
        }

        private StringTypeConditionWithPriority(String typeName, Priority priority, StringTypeConditionWithPriority[] instances) {
            super(typeName);
            this.myInstances = instances;
            super.setPriority(priority);
            instances[priority.ordinal()] = this;
        }

        public StringTypeConditionWithPriority withPriority(Priority priority) {
            StringTypeConditionWithPriority res = this.myInstances[priority.ordinal()];
            if (res == null) {
                res = new StringTypeConditionWithPriority(this.myTypeName, priority, this.myInstances);
            }
            return res;
        }

        @Override
        public NamedArgumentDescriptor setPriority(@NotNull Priority priority) {
            if (priority == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/extensions/NamedArgumentDescriptor$StringTypeConditionWithPriority", "setPriority"));
            }
            throw new UnsupportedOperationException("Use withPriority(priority)");
        }
    }

    public static enum Priority {
        ALWAYS_ON_TOP,
        AS_LOCAL_VARIABLE,
        NORMAL,
        UNLIKELY;

    }

    public static class NamedArgumentReference
    extends PsiPolyVariantReferenceBase<GrArgumentLabel> {
        private final PsiElement myNavigationElement;
        private final PsiSubstitutor mySubstitutor;

        public NamedArgumentReference(GrArgumentLabel element, @NotNull PsiElement navigationElement, PsiSubstitutor substitutor) {
            if (navigationElement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/extensions/NamedArgumentDescriptor$NamedArgumentReference", "<init>"));
            }
            super((PsiElement)element);
            this.myNavigationElement = navigationElement;
            this.mySubstitutor = substitutor;
        }

        public PsiElement resolve() {
            return this.myNavigationElement;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/extensions/NamedArgumentDescriptor$NamedArgumentReference", "bindToElement"));
            }
            if (element == this.myNavigationElement) {
                return this.getElement();
            }
            return super.bindToElement(element);
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            PsiElement resolved = this.resolve();
            if (resolved instanceof PsiMethod) {
                String newPropertyName;
                PsiMethod method = (PsiMethod)resolved;
                String oldName = ((GrArgumentLabel)this.getElement()).getName();
                if (!method.getName().equals(oldName) && PropertyUtil.isSimplePropertySetter((PsiMethod)method) && (newPropertyName = PropertyUtil.getPropertyName((String)newElementName)) != null) {
                    newElementName = newPropertyName;
                }
            }
            return super.handleElementRename(newElementName);
        }

        @NotNull
        public Object[] getVariants() {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/extensions/NamedArgumentDescriptor$NamedArgumentReference", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        @NotNull
        public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
            GroovyResolveResult[] groovyResolveResultArray = new GroovyResolveResult[]{new GroovyResolveResultImpl(this.myNavigationElement, null, null, this.mySubstitutor, true, true)};
            if (groovyResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/extensions/NamedArgumentDescriptor$NamedArgumentReference", "multiResolve"));
            }
            return groovyResolveResultArray;
        }
    }
}

