/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.extensions;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairFunction;
import com.intellij.util.SingletonInstancesCache;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.extensions.GroovyMethodDescriptor;
import org.jetbrains.plugins.groovy.extensions.GroovyMethodDescriptorExtension;
import org.jetbrains.plugins.groovy.extensions.GroovyMethodDescriptorTag;
import org.jetbrains.plugins.groovy.extensions.GroovyNamedArgumentProvider;
import org.jetbrains.plugins.groovy.extensions.GroovyNamedArgumentReferenceProvider;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.resolve.ClosureMissingMethodContributor;
import org.jetbrains.plugins.groovy.refactoring.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.util.FixedValuesReferenceProvider;

public class GroovyMethodInfo {
    private static volatile Map<String, Map<String, List<GroovyMethodInfo>>> METHOD_INFOS;
    private static Map<String, Map<String, List<GroovyMethodInfo>>> LIGHT_METHOD_INFOS;
    private static final Set<String> myAllSupportedNamedArguments;
    private final List<String> myParams;
    private final ClassLoader myClassLoader;
    private final String myReturnType;
    private final String myReturnTypeCalculatorClassName;
    private PairFunction<GrMethodCall, PsiMethod, PsiType> myReturnTypeCalculatorInstance;
    private final Map<String, NamedArgumentDescriptor> myNamedArguments;
    private final String myNamedArgProviderClassName;
    private GroovyNamedArgumentProvider myNamedArgProviderInstance;
    private Map<String, NamedArgumentReference> myNamedArgReferenceProviders;
    private final GroovyMethodDescriptor myDescriptor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureInit() {
        if (METHOD_INFOS != null) {
            return;
        }
        Class<GroovyMethodInfo> clazz = GroovyMethodInfo.class;
        synchronized (GroovyMethodInfo.class) {
            HashMap<String, Map<String, List<GroovyMethodInfo>>> methodInfos = new HashMap<String, Map<String, List<GroovyMethodInfo>>>();
            HashMap<String, Map<String, List<GroovyMethodInfo>>> lightMethodInfos = new HashMap<String, Map<String, List<GroovyMethodInfo>>>();
            for (GroovyClassDescriptor groovyClassDescriptor : (GroovyClassDescriptor[])GroovyClassDescriptor.EP_NAME.getExtensions()) {
                ClassLoader classLoader = groovyClassDescriptor.getLoaderForClass();
                for (GroovyMethodDescriptorTag method : groovyClassDescriptor.methods) {
                    GroovyMethodInfo.addMethodDescriptor(methodInfos, method, classLoader, groovyClassDescriptor.className);
                }
            }
            for (GroovyMethodDescriptorExtension groovyMethodDescriptorExtension : (GroovyMethodDescriptorExtension[])GroovyMethodDescriptorExtension.EP_NAME.getExtensions()) {
                if (groovyMethodDescriptorExtension.className != null) {
                    assert (groovyMethodDescriptorExtension.lightMethodKey == null);
                    GroovyMethodInfo.addMethodDescriptor(methodInfos, groovyMethodDescriptorExtension, groovyMethodDescriptorExtension.getLoaderForClass(), groovyMethodDescriptorExtension.className);
                    continue;
                }
                assert (groovyMethodDescriptorExtension.className == null);
                GroovyMethodInfo.addMethodDescriptor(lightMethodInfos, groovyMethodDescriptorExtension, groovyMethodDescriptorExtension.getLoaderForClass(), groovyMethodDescriptorExtension.lightMethodKey);
            }
            GroovyMethodInfo.processUnnamedDescriptors(lightMethodInfos);
            GroovyMethodInfo.processUnnamedDescriptors(methodInfos);
            LIGHT_METHOD_INFOS = lightMethodInfos;
            METHOD_INFOS = methodInfos;
            // ** MonitorExit[clazz] (shouldn't be in output)
            return;
        }
    }

    private static void processUnnamedDescriptors(Map<String, Map<String, List<GroovyMethodInfo>>> map) {
        for (Map<String, List<GroovyMethodInfo>> methodMap : map.values()) {
            List<GroovyMethodInfo> unnamedMethodDescriptors = methodMap.get(null);
            if (unnamedMethodDescriptors == null) continue;
            for (Map.Entry<String, List<GroovyMethodInfo>> entry : methodMap.entrySet()) {
                if (entry.getKey() == null) continue;
                entry.getValue().addAll(unnamedMethodDescriptors);
            }
        }
    }

    @Nullable
    private static List<GroovyMethodInfo> getInfos(Map<String, Map<String, List<GroovyMethodInfo>>> map, String key, PsiMethod method) {
        Map<String, List<GroovyMethodInfo>> methodMap = map.get(key);
        if (methodMap == null) {
            return null;
        }
        List<GroovyMethodInfo> res = methodMap.get(method.getName());
        if (res == null) {
            res = methodMap.get(null);
        }
        return res;
    }

    public static List<GroovyMethodInfo> getInfos(PsiMethod method) {
        GroovyMethodInfo.ensureInit();
        List<GroovyMethodInfo> lightMethodInfos = null;
        Object methodKind = GrLightMethodBuilder.getMethodKind((PsiElement)method);
        if (methodKind instanceof String) {
            lightMethodInfos = GroovyMethodInfo.getInfos(LIGHT_METHOD_INFOS, (String)methodKind, method);
        }
        List<GroovyMethodInfo> methodInfos = null;
        PsiClass containingClass = method.getContainingClass();
        if (containingClass != null) {
            methodInfos = GroovyMethodInfo.getInfos(METHOD_INFOS, containingClass.getQualifiedName(), method);
        }
        if (methodInfos == null) {
            return lightMethodInfos == null ? Collections.emptyList() : lightMethodInfos;
        }
        if (lightMethodInfos == null) {
            return methodInfos;
        }
        return ContainerUtil.concat(lightMethodInfos, methodInfos);
    }

    private GroovyMethodInfo(GroovyMethodDescriptor method, @NotNull ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/extensions/GroovyMethodInfo", "<init>"));
        }
        this.myClassLoader = classLoader;
        this.myDescriptor = method;
        this.myParams = method.getParams();
        this.myReturnType = method.returnType;
        this.myReturnTypeCalculatorClassName = method.returnTypeCalculator;
        assert (this.myReturnType == null || this.myReturnTypeCalculatorClassName == null);
        this.myNamedArguments = method.getArgumentsMap();
        this.myNamedArgProviderClassName = method.namedArgsProvider;
        this.myNamedArgReferenceProviders = GroovyMethodInfo.getNamedArgumentsReferenceProviders(method);
        myAllSupportedNamedArguments.addAll(this.myNamedArgReferenceProviders.keySet());
        if (ApplicationManager.getApplication().isInternal()) {
            this.assertClassExists(this.myNamedArgProviderClassName, GroovyNamedArgumentProvider.class);
            this.assertClassExists(this.myReturnTypeCalculatorClassName, PairFunction.class);
            for (NamedArgumentReference r : this.myNamedArgReferenceProviders.values()) {
                this.assertClassExists(r.myProviderClassName, PsiReferenceProvider.class, GroovyNamedArgumentReferenceProvider.class);
            }
            if (method.myClosureArguments != null) {
                for (GroovyMethodDescriptor.ClosureArgument argument : method.myClosureArguments) {
                    this.assertClassExists(argument.methodContributor, ClosureMissingMethodContributor.class);
                }
            }
        }
    }

    private void assertClassExists(@Nullable String className, Class<?> ... types) {
        if (className == null) {
            return;
        }
        try {
            Class<?> aClass = this.myClassLoader.loadClass(className);
            for (Class<?> t : types) {
                if (!t.isAssignableFrom(aClass)) continue;
                return;
            }
            assert (false) : "Incorrect class type: " + aClass + " must be one of " + Arrays.asList(types);
            assert (Modifier.isPublic(aClass.getConstructor(ArrayUtil.EMPTY_CLASS_ARRAY).getModifiers()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public GroovyMethodDescriptor getDescriptor() {
        return this.myDescriptor;
    }

    private static Map<String, NamedArgumentReference> getNamedArgumentsReferenceProviders(GroovyMethodDescriptor methodDescriptor) {
        if (methodDescriptor.myArguments == null) {
            return Collections.emptyMap();
        }
        HashMap<String, NamedArgumentReference> res = new HashMap<String, NamedArgumentReference>();
        for (GroovyMethodDescriptor.NamedArgument argument : methodDescriptor.myArguments) {
            NamedArgumentReference r;
            if (argument.referenceProvider != null) {
                assert (argument.values == null);
                r = new NamedArgumentReference(argument.referenceProvider);
            } else {
                if (argument.values == null) continue;
                ArrayList<String> values = new ArrayList<String>();
                StringTokenizer st = new StringTokenizer(argument.values, " ,;");
                while (st.hasMoreTokens()) {
                    values.add(st.nextToken());
                }
                r = new NamedArgumentReference(values.toArray(new String[values.size()]));
            }
            for (String name : argument.getNames()) {
                NamedArgumentReference oldValue = res.put(name, r);
                assert (oldValue == null);
            }
        }
        return res;
    }

    private static void addMethodDescriptor(Map<String, Map<String, List<GroovyMethodInfo>>> res, GroovyMethodDescriptor method, @NotNull ClassLoader classLoader, @NotNull String key) {
        if (classLoader == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/extensions/GroovyMethodInfo", "addMethodDescriptor"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/groovy/extensions/GroovyMethodInfo", "addMethodDescriptor"));
        }
        if (method.methodName == null) {
            GroovyMethodInfo.addMethodDescriptor(res, method, classLoader, null, key);
        } else {
            StringTokenizer st = new StringTokenizer(method.methodName, " \t,;");
            while (st.hasMoreTokens()) {
                String name = st.nextToken();
                assert (GroovyNamesUtil.isIdentifier(name));
                GroovyMethodInfo.addMethodDescriptor(res, method, classLoader, name, key);
            }
        }
    }

    private static void addMethodDescriptor(Map<String, Map<String, List<GroovyMethodInfo>>> res, GroovyMethodDescriptor method, @NotNull ClassLoader classLoader, @Nullable String methodName, @NotNull String key) {
        List<GroovyMethodInfo> methodsList;
        if (classLoader == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/extensions/GroovyMethodInfo", "addMethodDescriptor"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/plugins/groovy/extensions/GroovyMethodInfo", "addMethodDescriptor"));
        }
        Map<String, List<GroovyMethodInfo>> methodMap = res.get(key);
        if (methodMap == null) {
            methodMap = new HashMap<String, List<GroovyMethodInfo>>();
            res.put(key, methodMap);
        }
        if ((methodsList = methodMap.get(methodName)) == null) {
            methodsList = new ArrayList<GroovyMethodInfo>();
            methodMap.put(methodName, methodsList);
        }
        methodsList.add(new GroovyMethodInfo(method, classLoader));
    }

    @Nullable
    public String getReturnType() {
        return this.myReturnType;
    }

    public boolean isReturnTypeCalculatorDefined() {
        return this.myReturnTypeCalculatorClassName != null;
    }

    @NotNull
    public PairFunction<GrMethodCall, PsiMethod, PsiType> getReturnTypeCalculator() {
        if (this.myReturnTypeCalculatorInstance == null) {
            this.myReturnTypeCalculatorInstance = (PairFunction)SingletonInstancesCache.getInstance((String)this.myReturnTypeCalculatorClassName, (ClassLoader)this.myClassLoader);
        }
        PairFunction<GrMethodCall, PsiMethod, PsiType> pairFunction = this.myReturnTypeCalculatorInstance;
        if (pairFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/extensions/GroovyMethodInfo", "getReturnTypeCalculator"));
        }
        return pairFunction;
    }

    public static Set<String> getAllSupportedNamedArguments() {
        GroovyMethodInfo.ensureInit();
        return myAllSupportedNamedArguments;
    }

    @Nullable
    public Object getNamedArgReferenceProvider(String namedArgumentName) {
        NamedArgumentReference r = this.myNamedArgReferenceProviders.get(namedArgumentName);
        if (r == null) {
            return null;
        }
        return r.getProvider(this.myClassLoader);
    }

    @Nullable
    public Map<String, NamedArgumentDescriptor> getNamedArguments() {
        return this.myNamedArguments;
    }

    public boolean isNamedArgumentProviderDefined() {
        return this.myNamedArgProviderClassName != null;
    }

    public GroovyNamedArgumentProvider getNamedArgProvider() {
        if (this.myNamedArgProviderInstance == null) {
            this.myNamedArgProviderInstance = (GroovyNamedArgumentProvider)SingletonInstancesCache.getInstance((String)this.myNamedArgProviderClassName, (ClassLoader)this.myClassLoader);
        }
        return this.myNamedArgProviderInstance;
    }

    public ClassLoader getPluginClassLoader() {
        return this.myClassLoader;
    }

    public boolean isApplicable(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/extensions/GroovyMethodInfo", "isApplicable"));
        }
        if (this.myParams == null) {
            return true;
        }
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.getParametersCount() != this.myParams.size()) {
            return false;
        }
        PsiParameter[] parameters = parameterList.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (TypesUtil.isClassType(parameters[i].getType(), this.myParams.get(i))) continue;
            return false;
        }
        return true;
    }

    static {
        myAllSupportedNamedArguments = new HashSet<String>();
    }

    private static class NamedArgumentReference {
        private final String myProviderClassName;
        private final String[] myValues;
        private volatile Object myProvider;

        public NamedArgumentReference(String providerClassName) {
            this.myProviderClassName = providerClassName;
            this.myValues = null;
        }

        public NamedArgumentReference(String[] values) {
            this.myValues = values;
            this.myProviderClassName = null;
        }

        private Object doGetProvider(ClassLoader classLoader) {
            if (this.myProviderClassName != null) {
                return SingletonInstancesCache.getInstance((String)this.myProviderClassName, (ClassLoader)classLoader);
            }
            return new FixedValuesReferenceProvider(this.myValues);
        }

        public Object getProvider(ClassLoader classLoader) {
            Object res = this.myProvider;
            if (res == null) {
                this.myProvider = res = this.doGetProvider(classLoader);
            }
            return res;
        }
    }
}

