/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.DelegatingScopeProcessor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.resolve.DefaultImportContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GroovyImportHelper {
    static boolean isImplicitlyImported(PsiElement element, String expectedName, GroovyFile file) {
        if (!(element instanceof PsiClass)) {
            return false;
        }
        PsiClass psiClass = (PsiClass)element;
        if (!expectedName.equals(psiClass.getName())) {
            return false;
        }
        String qname = psiClass.getQualifiedName();
        if (qname == null) {
            return false;
        }
        for (String importedClass : GroovyFileBase.IMPLICITLY_IMPORTED_CLASSES) {
            if (!qname.equals(importedClass)) continue;
            return true;
        }
        for (String pkg : GroovyImportHelper.getImplicitlyImportedPackages(file)) {
            if (!qname.equals(pkg + "." + expectedName) && (pkg.length() != 0 || !qname.equals(expectedName))) continue;
            return true;
        }
        return false;
    }

    public static LinkedHashSet<String> getImplicitlyImportedPackages(GroovyFile file) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        ContainerUtil.addAll(result, (Object[])GroovyFileBase.IMPLICITLY_IMPORTED_PACKAGES);
        for (DefaultImportContributor contributor : (DefaultImportContributor[])DefaultImportContributor.EP_NAME.getExtensions()) {
            result.addAll(contributor.appendImplicitlyImportedPackages(file));
        }
        return result;
    }

    public static boolean processImports(ResolveState state, PsiElement lastParent, PsiElement place, PsiScopeProcessor importProcessor, GrImportStatement[] importStatements, boolean shouldProcessOnDemand) {
        for (int i = importStatements.length - 1; i >= 0; --i) {
            GrImportStatement imp = importStatements[i];
            if (shouldProcessOnDemand != imp.isOnDemand() || imp.processDeclarations(importProcessor, state, lastParent, place)) continue;
            return false;
        }
        return true;
    }

    public static boolean processImplicitImports(@NotNull PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place, @NotNull GroovyFile file) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/editor/GroovyImportHelper", "processImplicitImports"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/plugins/groovy/editor/GroovyImportHelper", "processImplicitImports"));
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)file.getProject());
        DelegatingScopeProcessor packageSkipper = new DelegatingScopeProcessor(processor){

            public boolean execute(@NotNull PsiElement element, ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/editor/GroovyImportHelper$1", "execute"));
                }
                if (element instanceof PsiPackage) {
                    return true;
                }
                return super.execute(element, state);
            }
        };
        for (String implicitlyImported : GroovyImportHelper.getImplicitlyImportedPackages(file)) {
            PsiPackage aPackage = facade.findPackage(implicitlyImported);
            if (aPackage == null || aPackage.processDeclarations((PsiScopeProcessor)packageSkipper, state, lastParent, place)) continue;
            return false;
        }
        GroovyPsiManager groovyPsiManager = GroovyPsiManager.getInstance(file.getProject());
        for (String implicitlyImportedClass : GroovyFileBase.IMPLICITLY_IMPORTED_CLASSES) {
            PsiClass clazz = groovyPsiManager.findClassWithCache(implicitlyImportedClass, file.getResolveScope());
            if (clazz == null || ResolveUtil.processElement(processor, (PsiNamedElement)clazz, state)) continue;
            return false;
        }
        return true;
    }
}

