/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dgm;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.MultiMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrGdkMethodImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GdkMethodHolder {
    private static Key<CachedValue<GdkMethodHolder>> CACHED_NON_STATIC = Key.create((String)"Cached instance gdk method holder");
    private static Key<CachedValue<GdkMethodHolder>> CACHED_STATIC = Key.create((String)"Cached static gdk method holder");
    private final ConcurrentFactoryMap<String, MultiMap<String, PsiMethod>> myOriginalMethodsByNameAndType;
    private final NotNullLazyValue<MultiMap<String, PsiMethod>> myOriginalMethodByType;
    private final boolean myStatic;
    private final GlobalSearchScope myScope;
    private final PsiManager myPsiManager;

    private GdkMethodHolder(PsiClass categoryClass, boolean isStatic, GlobalSearchScope scope) {
        this.myStatic = isStatic;
        this.myScope = scope;
        final MultiMap byName = new MultiMap();
        this.myPsiManager = categoryClass.getManager();
        for (PsiMethod m : categoryClass.getMethods()) {
            PsiParameter[] params = m.getParameterList().getParameters();
            if (params.length == 0) continue;
            byName.putValue((Object)m.getName(), (Object)m);
        }
        this.myOriginalMethodByType = new VolatileNotNullLazyValue<MultiMap<String, PsiMethod>>(){

            @NotNull
            protected MultiMap<String, PsiMethod> compute() {
                MultiMap map = new MultiMap();
                for (PsiMethod method : byName.values()) {
                    if (!method.hasModifierProperty("public")) continue;
                    map.putValue((Object)GdkMethodHolder.this.getCategoryTargetType(method).getCanonicalText(), (Object)method);
                }
                MultiMap multiMap = map;
                if (multiMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/dgm/GdkMethodHolder$1", "compute"));
                }
                return multiMap;
            }
        };
        this.myOriginalMethodsByNameAndType = new ConcurrentFactoryMap<String, MultiMap<String, PsiMethod>>(){

            protected MultiMap<String, PsiMethod> create(String name) {
                MultiMap map = new MultiMap();
                for (PsiMethod method : byName.get((Object)name)) {
                    map.putValue((Object)GdkMethodHolder.this.getCategoryTargetType(method).getCanonicalText(), (Object)method);
                }
                return map;
            }
        };
    }

    private PsiType getCategoryTargetType(PsiMethod method) {
        PsiType parameterType = method.getParameterList().getParameters()[0].getType();
        return TypesUtil.boxPrimitiveType(TypeConversionUtil.erasure((PsiType)parameterType), this.myPsiManager, this.myScope);
    }

    public boolean processMethods(PsiScopeProcessor processor, ResolveState state, PsiType qualifierType, Project project) {
        MultiMap map;
        if (qualifierType == null) {
            return true;
        }
        NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
        String name = nameHint == null ? null : nameHint.getName(state);
        MultiMap multiMap = map = name != null ? (MultiMap)this.myOriginalMethodsByNameAndType.get((Object)name) : (MultiMap)this.myOriginalMethodByType.getValue();
        if (map.isEmpty()) {
            return true;
        }
        for (String superType : ResolveUtil.getAllSuperTypes(qualifierType, project).keySet()) {
            for (PsiMethod method : map.get((Object)superType)) {
                String info;
                GrGdkMethod gdk = GrGdkMethodImpl.createGdkMethod(method, this.myStatic, info = GdkMethodUtil.generateOriginInfo(method));
                if (processor.execute((PsiElement)gdk, state)) continue;
                return false;
            }
        }
        return true;
    }

    public static GdkMethodHolder getHolderForClass(final PsiClass categoryClass, final boolean isStatic, final GlobalSearchScope scope) {
        final Project project = categoryClass.getProject();
        Key<CachedValue<GdkMethodHolder>> key = isStatic ? CACHED_STATIC : CACHED_NON_STATIC;
        return (GdkMethodHolder)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)categoryClass, key, (CachedValueProvider)new CachedValueProvider<GdkMethodHolder>(){

            public CachedValueProvider.Result<GdkMethodHolder> compute() {
                GdkMethodHolder result = new GdkMethodHolder(categoryClass, isStatic, scope);
                ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project);
                VirtualFile vfile = categoryClass.getContainingFile().getVirtualFile();
                if (vfile != null && (rootManager.getFileIndex().isInLibraryClasses(vfile) || rootManager.getFileIndex().isInLibrarySource(vfile))) {
                    return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{rootManager});
                }
                return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT, rootManager});
            }
        }, false);
    }
}

