/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.debugger.fragments;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.IntentionFilterOwner;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnAmbiguousClosureContainer;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileImpl;

public class GroovyCodeFragment
extends GroovyFileImpl
implements JavaCodeFragment,
IntentionFilterOwner,
GrUnAmbiguousClosureContainer {
    private PsiType myThisType;
    private PsiType mySuperType;
    private JavaCodeFragment.ExceptionHandler myExceptionChecker;
    private IntentionFilterOwner.IntentionActionsFilter myFilter;
    private GlobalSearchScope myResolveScope;
    private final LinkedHashMap<String, GrImportStatement> myPseudoImports = ContainerUtil.newLinkedHashMap();
    private final ArrayList<GrImportStatement> myOnDemandImports = ContainerUtil.newArrayList();
    private FileViewProvider myViewProvider = null;

    public GroovyCodeFragment(Project project, CharSequence text) {
        this(project, (VirtualFile)new LightVirtualFile("Dummy.groovy", (FileType)GroovyFileType.GROOVY_FILE_TYPE, text));
    }

    public GroovyCodeFragment(Project project, VirtualFile virtualFile) {
        super((FileViewProvider)new SingleRootFileViewProvider(PsiManager.getInstance((Project)project), virtualFile, true));
        ((SingleRootFileViewProvider)this.getViewProvider()).forceCachedPsi((PsiFile)this);
    }

    public void setThisType(PsiType thisType) {
        this.myThisType = thisType;
    }

    public PsiType getSuperType() {
        return this.mySuperType;
    }

    public void setSuperType(PsiType superType) {
        this.mySuperType = superType;
    }

    @NotNull
    public FileViewProvider getViewProvider() {
        if (this.myViewProvider != null) {
            FileViewProvider fileViewProvider = this.myViewProvider;
            if (fileViewProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/debugger/fragments/GroovyCodeFragment", "getViewProvider"));
            }
            return fileViewProvider;
        }
        FileViewProvider fileViewProvider = super.getViewProvider();
        if (fileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/debugger/fragments/GroovyCodeFragment", "getViewProvider"));
        }
        return fileViewProvider;
    }

    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        PsiElement context = this.getContext();
        return context == null || context.isValid();
    }

    public String importsToString() {
        if (this.myPseudoImports.isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry<String, GrImportStatement> entry : this.myPseudoImports.entrySet()) {
            String importedName = entry.getKey();
            GrImportStatement anImport = entry.getValue();
            String qname = anImport.getImportReference().getClassNameText();
            buffer.append(qname);
            buffer.append(':').append(importedName);
            buffer.append(',');
        }
        for (GrImportStatement anImport : this.myOnDemandImports) {
            String packName = anImport.getImportReference().getClassNameText();
            buffer.append(packName);
            buffer.append(',');
        }
        buffer.deleteCharAt(buffer.length() - 1);
        return buffer.toString();
    }

    public void addImportsFromString(String imports) {
        for (String anImport : imports.split(",")) {
            int colon = anImport.indexOf(58);
            if (colon >= 0) {
                String qname = anImport.substring(0, colon);
                String importedName = anImport.substring(colon + 1);
                this.myPseudoImports.put(importedName, this.createSingleImport(qname, importedName));
                continue;
            }
            this.myOnDemandImports.add(this.createImportOnDemand(anImport));
        }
    }

    public void setVisibilityChecker(JavaCodeFragment.VisibilityChecker checker) {
    }

    public JavaCodeFragment.VisibilityChecker getVisibilityChecker() {
        return JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE;
    }

    public void setExceptionHandler(JavaCodeFragment.ExceptionHandler checker) {
        this.myExceptionChecker = checker;
    }

    public JavaCodeFragment.ExceptionHandler getExceptionHandler() {
        return this.myExceptionChecker;
    }

    public void setIntentionActionsFilter(@NotNull IntentionFilterOwner.IntentionActionsFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/debugger/fragments/GroovyCodeFragment", "setIntentionActionsFilter"));
        }
        this.myFilter = filter;
    }

    public IntentionFilterOwner.IntentionActionsFilter getIntentionActionsFilter() {
        return this.myFilter;
    }

    public void forceResolveScope(GlobalSearchScope scope) {
        this.myResolveScope = scope;
    }

    public GlobalSearchScope getForcedResolveScope() {
        return this.myResolveScope;
    }

    @Override
    public boolean importClass(PsiClass aClass) {
        return false;
    }

    public PsiType getThisType() {
        return this.myThisType;
    }

    @Override
    protected boolean processImports(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place, GrImportStatement[] importStatements, boolean onDemand) {
        if (!super.processImports(processor, state, lastParent, place, importStatements, onDemand)) {
            return false;
        }
        return this.processPseudoImports(processor, state, lastParent, place, onDemand);
    }

    @Override
    protected GroovyCodeFragment clone() {
        GroovyCodeFragment clone = (GroovyCodeFragment)this.cloneImpl((FileElement)this.calcTreeElement().clone());
        clone.myOriginalFile = this;
        clone.myPseudoImports.putAll(this.myPseudoImports);
        FileManager fileManager = ((PsiManagerEx)this.getManager()).getFileManager();
        SingleRootFileViewProvider cloneViewProvider = (SingleRootFileViewProvider)fileManager.createFileViewProvider((VirtualFile)new LightVirtualFile(this.getName(), this.getLanguage(), (CharSequence)this.getText()), false);
        cloneViewProvider.forceCachedPsi((PsiFile)clone);
        clone.myViewProvider = cloneViewProvider;
        return clone;
    }

    protected boolean processPseudoImports(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place, boolean onDemand) {
        return !(onDemand ? !this.processImportsOnDemand(processor, state, lastParent, place) : !this.processSingleImports(processor, state, lastParent, place));
    }

    private boolean processImportsOnDemand(PsiScopeProcessor processor, ResolveState state, PsiElement parent, PsiElement place) {
        for (GrImportStatement anImport : this.myOnDemandImports) {
            if (anImport.processDeclarations(processor, state, parent, place)) continue;
            return false;
        }
        return true;
    }

    private boolean processSingleImports(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        String name;
        NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
        String string = name = nameHint != null ? nameHint.getName(state) : null;
        if (name != null) {
            GrImportStatement anImport = this.myPseudoImports.get(name);
            if (anImport != null && !anImport.processDeclarations(processor, state, lastParent, place)) {
                return false;
            }
        } else {
            for (GrImportStatement anImport : this.myPseudoImports.values()) {
                if (anImport.processDeclarations(processor, state, lastParent, place)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    private GrImportStatement createImportOnDemand(@NotNull String qname) {
        if (qname == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/debugger/fragments/GroovyCodeFragment", "createImportOnDemand"));
        }
        PsiClass aClass = JavaPsiFacade.getInstance((Project)this.getProject()).findClass(qname, this.getResolveScope());
        boolean isStatic = aClass != null;
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
        try {
            return factory.createImportStatement(qname, isStatic, true, null, this);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Nullable
    private GrImportStatement createSingleImport(@NotNull String qname, @Nullable String importedName) {
        if (qname == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/debugger/fragments/GroovyCodeFragment", "createSingleImport"));
        }
        PsiClass aClass = JavaPsiFacade.getInstance((Project)this.getProject()).findClass(qname, this.getResolveScope());
        boolean isStatic = aClass == null;
        String className = PsiNameHelper.getShortClassName((String)qname);
        String alias = importedName == null || className.equals(importedName) ? null : importedName;
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
        try {
            return factory.createImportStatement(qname, isStatic, false, alias, this);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    public void clearImports() {
        this.myPseudoImports.clear();
        this.myOnDemandImports.clear();
    }
}

