/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.debugger;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.JavaProgramPatcher;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.debugger.filters.GroovyDebuggerSettings;

public class GroovyHotSwapper
extends JavaProgramPatcher {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.debugger.GroovyHotSwapper");
    private static final String GROOVY_HOTSWAP_AGENT_PATH = "groovy.hotswap.agent.path";
    private static final Pattern SPRING_LOADED_PATTERN = Pattern.compile("-javaagent:.+springloaded-[^/\\\\]+\\.jar");

    private static boolean containsGroovyClasses(final Project project) {
        return (Boolean)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, (CachedValueProvider)new CachedValueProvider<Boolean>(){

            @Nullable
            public CachedValueProvider.Result<Boolean> compute() {
                return CachedValueProvider.Result.create((Object)FileTypeIndex.containsFileOfType((FileType)GroovyFileType.GROOVY_FILE_TYPE, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project)), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
        });
    }

    private static boolean hasSpringLoadedReloader(JavaParameters javaParameters) {
        for (String param : javaParameters.getVMParametersList().getParameters()) {
            if (!SPRING_LOADED_PATTERN.matcher(param).matches()) continue;
            return true;
        }
        return false;
    }

    public void patchJavaParameters(Executor executor, RunProfile configuration, JavaParameters javaParameters) {
        String agentPath;
        String vendor;
        LanguageLevel level;
        Module module;
        if (!executor.getId().equals(DefaultDebugExecutor.EXECUTOR_ID)) {
            return;
        }
        if (!GroovyDebuggerSettings.getInstance().ENABLE_GROOVY_HOTSWAP) {
            return;
        }
        if (GroovyHotSwapper.hasSpringLoadedReloader(javaParameters)) {
            return;
        }
        if (!(configuration instanceof RunConfiguration)) {
            return;
        }
        Project project = ((RunConfiguration)configuration).getProject();
        if (project == null) {
            return;
        }
        if (!LanguageLevelProjectExtension.getInstance((Project)project).getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_5)) {
            return;
        }
        if (configuration instanceof ModuleBasedConfiguration && (module = ((ModuleBasedConfiguration)configuration).getConfigurationModule().getModule()) != null && (level = LanguageLevelModuleExtension.getInstance((Module)module).getLanguageLevel()) != null && !level.isAtLeast(LanguageLevel.JDK_1_5)) {
            return;
        }
        Sdk jdk = javaParameters.getJdk();
        if (jdk != null && (vendor = JdkUtil.getJdkMainAttribute((Sdk)jdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VENDOR)) != null && vendor.contains("IBM")) {
            LOG.info("Due to IBM JDK pecularities (IDEA-59070) we don't add groovy agent when running applications under it");
            return;
        }
        if (!project.isDefault() && GroovyHotSwapper.containsGroovyClasses(project) && (agentPath = GroovyHotSwapper.handleSpacesInPath(GroovyHotSwapper.getAgentJarPath())) != null) {
            javaParameters.getVMParametersList().add("-javaagent:" + agentPath);
        }
    }

    @Nullable
    private static String handleSpacesInPath(String agentPath) {
        if (agentPath.contains(" ")) {
            File dir = new File(PathManager.getSystemPath(), "groovyHotSwap");
            if (dir.getAbsolutePath().contains(" ")) {
                LOG.info("Groovy hot-swap not used since the agent path contains spaces: " + agentPath + "\n" + "One can move the agent to a directory with no spaces in path and specify its path in <IDEA dist>/bin/idea.properties as " + GROOVY_HOTSWAP_AGENT_PATH + "=<path>");
                return null;
            }
            File toFile = new File(dir, "gragent.jar");
            try {
                FileUtil.copy((File)new File(agentPath), (File)toFile);
                return toFile.getPath();
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        return agentPath;
    }

    private static String getAgentJarPath() {
        String userDefined = System.getProperty(GROOVY_HOTSWAP_AGENT_PATH);
        if (userDefined != null && new File(userDefined).exists()) {
            return userDefined;
        }
        File ourJar = new File(PathUtil.getJarPathForClass(GroovyHotSwapper.class));
        if (ourJar.isDirectory()) {
            return PluginPathManager.getPluginHomePath((String)"groovy") + "/hotswap/gragent.jar";
        }
        File pluginDir = ourJar.getParentFile();
        return pluginDir.getPath() + File.separator + "agent" + File.separator + "gragent.jar";
    }
}

