/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.debugger.fragments.GroovyCodeFragment;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightVariable;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;

public class GroovyShellCodeFragment
extends GroovyCodeFragment {
    private final Map<String, PsiVariable> myVariables = ContainerUtil.newHashMap();
    private final Map<String, GrTypeDefinition> myTypeDefinitions = ContainerUtil.newHashMap();

    public GroovyShellCodeFragment(Project project, LightVirtualFile virtualFile) {
        super(project, (VirtualFile)virtualFile);
    }

    @Override
    protected GroovyCodeFragment clone() {
        GroovyShellCodeFragment clone = (GroovyShellCodeFragment)super.clone();
        clone.myVariables.putAll(this.myVariables);
        clone.myTypeDefinitions.putAll(this.myTypeDefinitions);
        return clone;
    }

    public void addVariable(String name, GrExpression expr) {
        this.myVariables.put(name, new GrLightVariable(this.getManager(), name, expr.getType(), (PsiElement)this));
    }

    public void addVariable(String name, PsiType type) {
        this.myVariables.put(name, new GrLightVariable(this.getManager(), name, type, (PsiElement)this));
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/console/GroovyShellCodeFragment", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/console/GroovyShellCodeFragment", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/groovy/console/GroovyShellCodeFragment", "processDeclarations"));
        }
        if (!super.processDeclarations(processor, state, lastParent, place)) {
            return false;
        }
        if (!this.processVariables(processor, state)) {
            return false;
        }
        return this.processTypeDefinitions(processor, state);
    }

    private boolean processVariables(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
        String name;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/console/GroovyShellCodeFragment", "processVariables"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/console/GroovyShellCodeFragment", "processVariables"));
        }
        ClassHint classHint = (ClassHint)processor.getHint(ClassHint.KEY);
        if (classHint != null && !classHint.shouldProcess(ClassHint.ResolveKind.METHOD) && !classHint.shouldProcess(ClassHint.ResolveKind.PROPERTY)) {
            return true;
        }
        NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
        String string = name = nameHint != null ? nameHint.getName(state) : null;
        if (name != null) {
            PsiVariable var = this.myVariables.get(name);
            if (var != null && processor.execute((PsiElement)var, state)) {
                return false;
            }
        } else {
            for (PsiVariable var : this.myVariables.values()) {
                if (processor.execute((PsiElement)var, state)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean processTypeDefinitions(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
        String name;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/console/GroovyShellCodeFragment", "processTypeDefinitions"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/console/GroovyShellCodeFragment", "processTypeDefinitions"));
        }
        ClassHint classHint = (ClassHint)processor.getHint(ClassHint.KEY);
        if (classHint != null && !classHint.shouldProcess(ClassHint.ResolveKind.CLASS)) {
            return true;
        }
        NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
        String string = name = nameHint != null ? nameHint.getName(state) : null;
        if (name != null) {
            GrTypeDefinition definition = this.myTypeDefinitions.get(name);
            if (definition != null && processor.execute((PsiElement)definition, state)) {
                return false;
            }
        } else {
            for (GrTypeDefinition definition : this.myTypeDefinitions.values()) {
                if (processor.execute((PsiElement)definition, state)) continue;
                return false;
            }
        }
        return true;
    }

    public void addTypeDefinition(GrTypeDefinition typeDefinition) {
        this.myTypeDefinitions.put(typeDefinition.getName(), typeDefinition);
    }

    public void clearVariables() {
        this.myVariables.clear();
    }

    public void clearClasses() {
        this.myTypeDefinitions.clear();
    }
}

