/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.configSlurper;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.util.PairConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.configSlurper.ConfigSlurperSupport;
import org.jetbrains.plugins.groovy.extensions.GroovyMapContentProvider;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;

public class ConfigSlurperMapContentProvider
extends GroovyMapContentProvider {
    @Nullable
    private static Pair<ConfigSlurperSupport.PropertiesProvider, List<String>> getInfo(@NotNull GrExpression qualifier, @Nullable PsiElement resolve) {
        ConfigSlurperSupport slurperSupport;
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/configSlurper/ConfigSlurperMapContentProvider", "getInfo"));
        }
        if (!GroovyPsiManager.isInheritorCached(qualifier.getType(), "groovy.util.ConfigObject")) {
            return null;
        }
        GrExpression resolvedQualifier = qualifier;
        PsiElement resolveResult = resolve;
        ArrayList<String> path = new ArrayList<String>();
        while (resolveResult == null) {
            if (!(resolvedQualifier instanceof GrReferenceExpression)) {
                return null;
            }
            GrReferenceExpression expr = (GrReferenceExpression)resolvedQualifier;
            path.add(expr.getReferenceName());
            resolvedQualifier = expr.getQualifierExpression();
            if (resolvedQualifier instanceof GrReferenceExpression) {
                resolveResult = ((GrReferenceExpression)resolvedQualifier).resolve();
                continue;
            }
            if (resolvedQualifier instanceof GrMethodCall) {
                resolveResult = ((GrMethodCall)resolvedQualifier).resolveMethod();
                continue;
            }
            return null;
        }
        Collections.reverse(path);
        ConfigSlurperSupport.PropertiesProvider propertiesProvider = null;
        ConfigSlurperSupport[] arr$ = (ConfigSlurperSupport[])ConfigSlurperSupport.EP_NAME.getExtensions();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (propertiesProvider = (slurperSupport = arr$[i$]).getConfigSlurperInfo(resolvedQualifier, resolveResult)) == null; ++i$) {
        }
        if (propertiesProvider == null) {
            return null;
        }
        return Pair.create(propertiesProvider, path);
    }

    @Override
    protected Collection<String> getKeyVariants(@NotNull GrExpression qualifier, @Nullable PsiElement resolve) {
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/configSlurper/ConfigSlurperMapContentProvider", "getKeyVariants"));
        }
        Pair<ConfigSlurperSupport.PropertiesProvider, List<String>> info = ConfigSlurperMapContentProvider.getInfo(qualifier, resolve);
        if (info == null) {
            return Collections.emptyList();
        }
        final HashSet<String> res = new HashSet<String>();
        ((ConfigSlurperSupport.PropertiesProvider)info.first).collectVariants((List)info.second, new PairConsumer<String, Boolean>(){

            public void consume(String variant, Boolean isFinal) {
                res.add(variant);
            }
        });
        return res;
    }

    @Override
    public PsiType getValueType(@NotNull GrExpression qualifier, @Nullable PsiElement resolve, final @NotNull String key) {
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/configSlurper/ConfigSlurperMapContentProvider", "getValueType"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/configSlurper/ConfigSlurperMapContentProvider", "getValueType"));
        }
        Pair<ConfigSlurperSupport.PropertiesProvider, List<String>> info = ConfigSlurperMapContentProvider.getInfo(qualifier, resolve);
        if (info == null) {
            return null;
        }
        final Ref res = new Ref();
        ((ConfigSlurperSupport.PropertiesProvider)info.first).collectVariants((List)info.second, new PairConsumer<String, Boolean>(){

            public void consume(String variant, Boolean isFinal) {
                if (variant.equals(key)) {
                    res.set((Object)isFinal);
                } else if (variant.startsWith(key) && variant.length() > key.length() && variant.charAt(key.length()) == '.') {
                    res.set((Object)false);
                }
            }
        });
        if (res.get() != null && !((Boolean)res.get()).booleanValue()) {
            return JavaPsiFacade.getElementFactory((Project)qualifier.getProject()).createTypeByFQClassName("groovy.util.ConfigObject", qualifier.getResolveScope());
        }
        return null;
    }
}

