/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryPresentationProvider;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyLibraryProperties;

public abstract class GroovyLibraryPresentationProviderBase
extends LibraryPresentationProvider<GroovyLibraryProperties> {
    public GroovyLibraryPresentationProviderBase(LibraryKind kind) {
        super(kind);
    }

    public String getDescription(@NotNull GroovyLibraryProperties properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/config/GroovyLibraryPresentationProviderBase", "getDescription"));
        }
        String version = properties.getVersion();
        return this.getLibraryCategoryName() + " library" + (version != null ? " of version " + version : ":");
    }

    public GroovyLibraryProperties detect(@NotNull List<VirtualFile> classesRoots) {
        if (classesRoots == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/config/GroovyLibraryPresentationProviderBase", "detect"));
        }
        VirtualFile[] libraryFiles = VfsUtilCore.toVirtualFileArray(classesRoots);
        if (this.managesLibrary(libraryFiles)) {
            String version = this.getLibraryVersion(libraryFiles);
            return new GroovyLibraryProperties(version);
        }
        return null;
    }

    protected abstract void fillLibrary(String var1, LibraryEditor var2);

    public abstract boolean managesLibrary(VirtualFile[] var1);

    @Nullable
    @Nls
    public abstract String getLibraryVersion(VirtualFile[] var1);

    @NotNull
    public abstract Icon getIcon();

    public abstract boolean isSDKHome(@NotNull VirtualFile var1);

    @NotNull
    public abstract String getSDKVersion(String var1);

    @NotNull
    @Nls
    public abstract String getLibraryCategoryName();

    @NotNull
    @Nls
    public String getLibraryPrefix() {
        String string = StringUtil.toLowerCase((String)this.getLibraryCategoryName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/config/GroovyLibraryPresentationProviderBase", "getLibraryPrefix"));
        }
        return string;
    }

    public boolean managesName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/config/GroovyLibraryPresentationProviderBase", "managesName"));
        }
        return StringUtil.startsWithIgnoreCase((String)name, (String)this.getLibraryPrefix());
    }
}

