/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import icons.JetgroovyIcons;
import java.io.File;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.config.AbstractConfigUtils;
import org.jetbrains.plugins.groovy.util.GroovyUtils;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public abstract class GroovyConfigUtils
extends AbstractConfigUtils {
    @NonNls
    public static final Pattern GROOVY_ALL_JAR_PATTERN = Pattern.compile("groovy-all(-(.*))?\\.jar");
    @NonNls
    public static final Pattern GROOVY_JAR_PATTERN = Pattern.compile("groovy(-(\\d.*))?\\.jar");
    public static final String NO_VERSION = "<no version>";
    public static final String GROOVY1_7 = "1.7";
    public static final String GROOVY1_8 = "1.8";
    public static final String GROOVY2_0 = "2.0";
    public static final String GROOVY2_1 = "2.1";
    public static final String GROOVY2_2 = "2.2";
    public static final String GROOVY2_2_2 = "2.2.2";
    public static final String GROOVY2_3 = "2.3";
    private static GroovyConfigUtils myGroovyConfigUtils;

    private GroovyConfigUtils() {
    }

    public static GroovyConfigUtils getInstance() {
        if (myGroovyConfigUtils == null) {
            myGroovyConfigUtils = new GroovyConfigUtils(){
                {
                    this.STARTER_SCRIPT_FILE_NAME = "groovy";
                }
            };
        }
        return myGroovyConfigUtils;
    }

    @NotNull
    public static File[] getGroovyAllJars(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/config/GroovyConfigUtils", "getGroovyAllJars"));
        }
        File[] fileArray = GroovyUtils.getFilesInDirectoryByPattern(path, GROOVY_ALL_JAR_PATTERN);
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/config/GroovyConfigUtils", "getGroovyAllJars"));
        }
        return fileArray;
    }

    public static boolean matchesGroovyAll(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/config/GroovyConfigUtils", "matchesGroovyAll"));
        }
        return GROOVY_ALL_JAR_PATTERN.matcher(name).matches() && !name.contains("src") && !name.contains("doc");
    }

    @Override
    @NotNull
    public String getSDKVersion(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/config/GroovyConfigUtils", "getSDKVersion"));
        }
        String groovyJarVersion = GroovyConfigUtils.getSDKJarVersion(path + "/lib", GROOVY_JAR_PATTERN, "META-INF/MANIFEST.MF");
        if (groovyJarVersion == null) {
            groovyJarVersion = GroovyConfigUtils.getSDKJarVersion(path + "/lib", GROOVY_ALL_JAR_PATTERN, "META-INF/MANIFEST.MF");
        }
        if (groovyJarVersion == null) {
            groovyJarVersion = GroovyConfigUtils.getSDKJarVersion(path + "/embeddable", GROOVY_ALL_JAR_PATTERN, "META-INF/MANIFEST.MF");
        }
        if (groovyJarVersion == null) {
            groovyJarVersion = GroovyConfigUtils.getSDKJarVersion(path, GROOVY_ALL_JAR_PATTERN, "META-INF/MANIFEST.MF");
        }
        String string = groovyJarVersion == null ? "undefined" : groovyJarVersion;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/config/GroovyConfigUtils", "getSDKVersion"));
        }
        return string;
    }

    @Override
    public boolean isSDKLibrary(Library library) {
        if (library == null) {
            return false;
        }
        return LibrariesUtil.getGroovyLibraryHome(library.getFiles(OrderRootType.CLASSES)) != null;
    }

    @Nullable
    public String getSDKVersion(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/config/GroovyConfigUtils", "getSDKVersion"));
        }
        return (String)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, (CachedValueProvider)new CachedValueProvider<String>(){

            public CachedValueProvider.Result<String> compute() {
                String path = LibrariesUtil.getGroovyHomePath(module);
                if (path == null) {
                    return CachedValueProvider.Result.create(null, (Object[])new Object[]{ProjectRootManager.getInstance((Project)module.getProject())});
                }
                return CachedValueProvider.Result.create((Object)GroovyConfigUtils.this.getSDKVersion(path), (Object[])new Object[]{ProjectRootManager.getInstance((Project)module.getProject())});
            }
        });
    }

    public boolean isVersionAtLeast(PsiElement psiElement, String version) {
        return this.isVersionAtLeast(psiElement, version, true);
    }

    public boolean isVersionAtLeast(PsiElement psiElement, String version, boolean unknownResult) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (module == null) {
            return unknownResult;
        }
        String sdkVersion = this.getSDKVersion(module);
        if (sdkVersion == null) {
            return unknownResult;
        }
        return sdkVersion.compareTo(version) >= 0;
    }

    @NotNull
    public String getSDKVersion(PsiElement psiElement) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (module == null) {
            if (NO_VERSION == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/config/GroovyConfigUtils", "getSDKVersion"));
            }
            return NO_VERSION;
        }
        String s = this.getSDKVersion(module);
        String string = s != null ? s : NO_VERSION;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/config/GroovyConfigUtils", "getSDKVersion"));
        }
        return string;
    }

    @Override
    public boolean isSDKHome(VirtualFile file) {
        String path;
        return file != null && file.isDirectory() && (GroovyUtils.getFilesInDirectoryByPattern((path = file.getPath()) + "/lib", GROOVY_JAR_PATTERN).length > 0 || GroovyUtils.getFilesInDirectoryByPattern(path + "/embeddable", GROOVY_ALL_JAR_PATTERN).length > 0 || GroovyUtils.getFilesInDirectoryByPattern(path, GROOVY_JAR_PATTERN).length > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryToSetUpGroovyFacetOnTheFly(Module module) {
        Project project = module.getProject();
        Library[] libraries = this.getAllSDKLibraries(project);
        if (libraries.length > 0) {
            Library library = libraries[0];
            int result = Messages.showOkCancelDialog((String)GroovyBundle.message("groovy.like.library.found.text", module.getName(), library.getName(), this.getSDKLibVersion(library)), (String)GroovyBundle.message("groovy.like.library.found", new Object[0]), (Icon)JetgroovyIcons.Groovy.Groovy_32x32);
            if (result == 0) {
                AccessToken accessToken = WriteAction.start();
                try {
                    ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                    LibraryOrderEntry entry = model.addLibraryEntry(libraries[0]);
                    LibrariesUtil.placeEntryToCorrectPlace(model, entry);
                    model.commit();
                    boolean bl = true;
                    return bl;
                }
                finally {
                    accessToken.finish();
                }
            }
        }
        return false;
    }

    @NotNull
    public String getSDKLibVersion(Library library) {
        String string = this.getSDKVersion(LibrariesUtil.getGroovyLibraryHome(library));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/config/GroovyConfigUtils", "getSDKLibVersion"));
        }
        return string;
    }

    public Collection<String> getSDKVersions(Library[] libraries) {
        return ContainerUtil.map2List((Object[])libraries, (Function)new Function<Library, String>(){

            public String fun(Library library) {
                return GroovyConfigUtils.this.getSDKLibVersion(library);
            }
        });
    }
}

