/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.compiler;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.FileSetCompileScope;
import com.intellij.compiler.impl.TranslatingCompilerFilesMonitor;
import com.intellij.compiler.impl.javaCompiler.ModuleChunk;
import com.intellij.compiler.impl.javaCompiler.OutputItemImpl;
import com.intellij.compiler.make.CacheCorruptedException;
import com.intellij.compiler.make.DependencyCache;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.TranslatingCompiler;
import com.intellij.openapi.compiler.ex.CompileContextEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Chunk;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.SmartList;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.HttpConfigurable;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.groovy.compiler.rt.GroovycRunner;
import org.jetbrains.jps.incremental.groovy.GroovycOSProcessHandler;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.compiler.GroovyCompilerConfiguration;
import org.jetbrains.plugins.groovy.compiler.GroovyCompilerExtension;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptType;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptTypeDetector;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.util.GroovyUtils;

public abstract class GroovyCompilerBase
implements TranslatingCompiler {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.compiler.GroovyCompilerBase");
    protected final Project myProject;

    public GroovyCompilerBase(Project project) {
        this.myProject = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runGroovycCompiler(final CompileContext compileContext, Module module, List<VirtualFile> toCompile, boolean forStubs, VirtualFile outputDir, TranslatingCompiler.OutputSink sink, boolean tests) {
        File fileWithParameters;
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        assert (sdk != null);
        SdkTypeId sdkType = sdk.getSdkType();
        assert (sdkType instanceof JavaSdkType);
        String exePath = ((JavaSdkType)sdkType).getVMExecutablePath(sdk);
        JavaParameters parameters = new JavaParameters();
        PathsList classPathBuilder = parameters.getClassPath();
        classPathBuilder.add(PathUtil.getJarPathForClass(GroovycRunner.class));
        ModuleChunk chunk = GroovyCompilerBase.createChunk(module, compileContext);
        Library[] libraries = GroovyConfigUtils.getInstance().getSDKLibrariesByModule(module);
        if (libraries.length > 0) {
            classPathBuilder.addVirtualFiles(Arrays.asList(libraries[0].getFiles(OrderRootType.CLASSES)));
        }
        classPathBuilder.addVirtualFiles((Collection)chunk.getCompilationBootClasspathFiles(false));
        classPathBuilder.addVirtualFiles((Collection)chunk.getCompilationClasspathFiles(false));
        GroovyCompilerBase.appendOutputPath(module, classPathBuilder, false);
        if (tests) {
            GroovyCompilerBase.appendOutputPath(module, classPathBuilder, true);
        }
        SmartList patchers = new SmartList();
        AccessToken accessToken = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            for (GroovyCompilerExtension extension : (GroovyCompilerExtension[])GroovyCompilerExtension.EP_NAME.getExtensions()) {
                extension.enhanceCompilationClassPath(chunk, classPathBuilder);
                patchers.addAll(extension.getCompilationUnitPatchers(chunk));
            }
        }
        finally {
            accessToken.finish();
        }
        boolean profileGroovyc = "true".equals(System.getProperty("profile.groovy.compiler"));
        if (profileGroovyc) {
            parameters.getVMParametersList().defineProperty("java.library.path", PathManager.getBinPath());
            parameters.getVMParametersList().defineProperty("profile.groovy.compiler", "true");
            parameters.getVMParametersList().add("-agentlib:yjpagent=disablej2ee,disablealloc,delay=10000,sessionname=GroovyCompiler");
            classPathBuilder.add(PathManager.findFileInLibDirectory((String)"yjp-controller-api-redist.jar").getAbsolutePath());
        }
        GroovyCompilerConfiguration compilerConfiguration = GroovyCompilerConfiguration.getInstance(this.myProject);
        parameters.getVMParametersList().add("-Xmx" + compilerConfiguration.getHeapSize() + "m");
        if (profileGroovyc) {
            parameters.getVMParametersList().add("-XX:+HeapDumpOnOutOfMemoryError");
        }
        parameters.getVMParametersList().addAll(HttpConfigurable.convertArguments((List)HttpConfigurable.getJvmPropertiesList((boolean)false, null)));
        ArrayList list = new ArrayList();
        CompilerUtil.addLocaleOptions(list, (boolean)false);
        for (String s : list) {
            parameters.getVMParametersList().add(s);
        }
        parameters.setMainClass(GroovycRunner.class.getName());
        ArrayList finalOutputs = ContainerUtil.newArrayList();
        for (Module eachModule : chunk.getModules()) {
            VirtualFile finalOutputDir = GroovyCompilerBase.getMainOutput(compileContext, eachModule, tests);
            if (finalOutputDir == null) {
                compileContext.addMessage(CompilerMessageCategory.ERROR, "No output directory for module " + eachModule.getName() + (tests ? " tests" : " production"), null, -1, -1);
                return;
            }
            finalOutputs.add(FileUtil.toSystemDependentName((String)finalOutputDir.getPath()));
        }
        Charset ideCharset = EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharset();
        String encoding = ideCharset != null && !Comparing.equal((Object)CharsetToolkit.getDefaultSystemCharset(), (Object)ideCharset) ? ideCharset.name() : null;
        Set paths2Compile = ContainerUtil.map2Set(toCompile, (Function)new Function<VirtualFile, String>(){

            public String fun(VirtualFile file) {
                return file.getPath();
            }
        });
        HashMap<String, String> class2Src = new HashMap<String, String>();
        for (VirtualFile file : this.enumerateGroovyFiles(module)) {
            if (paths2Compile.contains(file.getPath())) continue;
            for (String name : TranslatingCompilerFilesMonitor.getInstance().getCompiledClassNames(file, this.myProject)) {
                class2Src.put(name, file.getPath());
            }
        }
        try {
            fileWithParameters = GroovycOSProcessHandler.fillFileWithGroovycParameters((String)outputDir.getPath(), (Collection)paths2Compile, (Collection)finalOutputs, class2Src, (String)encoding, (List)patchers, (String)"");
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            compileContext.addMessage(CompilerMessageCategory.ERROR, "Error creating a temp file to launch Groovy compiler: " + e.getMessage(), null, -1, -1);
            return;
        }
        parameters.getProgramParametersList().add("do_not_optimize");
        parameters.getProgramParametersList().add(forStubs ? "stubs" : "groovyc");
        parameters.getProgramParametersList().add(fileWithParameters.getPath());
        if (compilerConfiguration.isInvokeDynamic()) {
            parameters.getProgramParametersList().add("--indy");
        }
        try {
            Process process = JdkUtil.setupJVMCommandLine((String)exePath, (SimpleJavaParameters)parameters, (boolean)true).createProcess();
            GroovycOSProcessHandler processHandler = GroovycOSProcessHandler.runGroovyc((Process)process, (Consumer)new Consumer<String>(){

                public void consume(String s) {
                    compileContext.getProgressIndicator().setText(s);
                }
            });
            ArrayList<VirtualFile> toRecompile = new ArrayList<VirtualFile>();
            for (File toRecompileFile : processHandler.getToRecompileFiles()) {
                VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(toRecompileFile);
                LOG.assertTrue(vFile != null);
                toRecompile.add(vFile);
            }
            for (CompilerMessage compilerMessage : processHandler.getCompilerMessages(module.getName())) {
                String url = compilerMessage.getSourcePath();
                compileContext.addMessage(GroovyCompilerBase.getMessageCategory(compilerMessage), compilerMessage.getMessageText(), url == null ? null : VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)url)), (int)compilerMessage.getLine(), (int)compilerMessage.getColumn());
            }
            List outputItems = processHandler.getSuccessfullyCompiled();
            ArrayList<OutputItemImpl> items = new ArrayList<OutputItemImpl>();
            if (forStubs) {
                ArrayList<String> outputPaths = new ArrayList<String>();
                for (GroovycOSProcessHandler.OutputItem outputItem : outputItems) {
                    outputPaths.add(outputItem.outputPath);
                }
                GroovyCompilerBase.addStubsToCompileScope(outputPaths, compileContext, module);
            } else {
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                if (indicator != null) {
                    indicator.setText("Updating caches...");
                }
                DependencyCache dependencyCache = ((CompileContextEx)compileContext).getDependencyCache();
                for (GroovycOSProcessHandler.OutputItem outputItem : outputItems) {
                    VirtualFile sourceVirtualFile = LocalFileSystem.getInstance().findFileByIoFile(new File(outputItem.sourcePath));
                    if (sourceVirtualFile == null) continue;
                    if (indicator != null) {
                        indicator.setText2(sourceVirtualFile.getName());
                    }
                    LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(outputItem.outputPath));
                    items.add(new OutputItemImpl(outputItem.outputPath, sourceVirtualFile));
                    File classFile = new File(outputItem.outputPath);
                    try {
                        dependencyCache.reparseClassFile(classFile, FileUtil.loadFileBytes((File)classFile));
                    }
                    catch (ClsFormatException e) {
                        LOG.error((Throwable)e);
                    }
                    catch (CacheCorruptedException e) {
                        LOG.error((Throwable)e);
                    }
                    catch (FileNotFoundException ignored) {
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
            sink.add(outputDir.getPath(), items, VfsUtilCore.toVirtualFileArray(toRecompile));
        }
        catch (ExecutionException e) {
            LOG.info((Throwable)e);
            compileContext.addMessage(CompilerMessageCategory.ERROR, "Error running Groovy compiler: " + e.getMessage(), null, -1, -1);
        }
    }

    protected Set<VirtualFile> enumerateGroovyFiles(Module module) {
        THashSet moduleClasses = new THashSet();
        ModuleRootManager.getInstance((Module)module).getFileIndex().iterateContent(new ContentIterator((Set)moduleClasses){
            final /* synthetic */ Set val$moduleClasses;
            {
                this.val$moduleClasses = set;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean processFile(VirtualFile vfile) {
                if (!vfile.isDirectory() && ((Object)((Object)GroovyFileType.GROOVY_FILE_TYPE)).equals(vfile.getFileType())) {
                    AccessToken accessToken = ApplicationManager.getApplication().acquireReadActionLock();
                    try {
                        if (PsiManager.getInstance((Project)GroovyCompilerBase.this.myProject).findFile(vfile) instanceof GroovyFile) {
                            this.val$moduleClasses.add(vfile);
                        }
                    }
                    finally {
                        accessToken.finish();
                    }
                }
                return true;
            }
        });
        return moduleClasses;
    }

    protected static void addStubsToCompileScope(List<String> outputPaths, CompileContext compileContext, Module module) {
        ArrayList stubFiles = new ArrayList();
        for (String outputPath : outputPaths) {
            File stub = new File(outputPath);
            CompilerUtil.refreshIOFile((File)stub);
            VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(stub);
            ContainerUtil.addIfNotNull((Object)file, stubFiles);
        }
        ((CompileContextEx)compileContext).addScope((CompileScope)new FileSetCompileScope(stubFiles, new Module[]{module}));
    }

    @Nullable
    protected static VirtualFile getMainOutput(CompileContext compileContext, Module module, boolean tests) {
        return tests ? compileContext.getModuleOutputDirectoryForTests(module) : compileContext.getModuleOutputDirectory(module);
    }

    private static CompilerMessageCategory getMessageCategory(CompilerMessage compilerMessage) {
        BuildMessage.Kind category = compilerMessage.getKind();
        if (BuildMessage.Kind.ERROR.equals((Object)category)) {
            return CompilerMessageCategory.ERROR;
        }
        if (BuildMessage.Kind.INFO.equals((Object)category)) {
            return CompilerMessageCategory.INFORMATION;
        }
        if (BuildMessage.Kind.WARNING.equals((Object)category)) {
            return CompilerMessageCategory.WARNING;
        }
        return CompilerMessageCategory.ERROR;
    }

    private static void appendOutputPath(Module module, PathsList compileClasspath, boolean forTestClasses) {
        String output = CompilerPaths.getModuleOutputPath((Module)module, (boolean)forTestClasses);
        if (output != null) {
            compileClasspath.add(FileUtil.toSystemDependentName((String)output));
        }
    }

    private static ModuleChunk createChunk(Module module, CompileContext context) {
        return new ModuleChunk((CompileContextEx)context, new Chunk((Object)module), Collections.emptyMap());
    }

    public void compile(CompileContext compileContext, Chunk<Module> moduleChunk, VirtualFile[] virtualFiles, TranslatingCompiler.OutputSink sink) {
        Map mapModulesToVirtualFiles = moduleChunk.getNodes().size() == 1 ? Collections.singletonMap(moduleChunk.getNodes().iterator().next(), Arrays.asList(virtualFiles)) : CompilerUtil.buildModuleToFilesMap((CompileContext)compileContext, (VirtualFile[])virtualFiles);
        for (Module module : moduleChunk.getNodes()) {
            List<VirtualFile> moduleFiles = mapModulesToVirtualFiles.get(module);
            if (moduleFiles == null) continue;
            ModuleFileIndex index = ModuleRootManager.getInstance((Module)module).getFileIndex();
            ArrayList<VirtualFile> toCompile = new ArrayList<VirtualFile>();
            ArrayList<VirtualFile> toCompileTests = new ArrayList<VirtualFile>();
            CompilerConfiguration configuration = CompilerConfiguration.getInstance((Project)this.myProject);
            PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
            if (GroovyUtils.isAcceptableModuleType(ModuleType.get((Module)module))) {
                for (VirtualFile file : moduleFiles) {
                    if (!GroovyCompilerBase.shouldCompile(file, configuration, psiManager)) continue;
                    (index.isInTestSourceContent(file) ? toCompileTests : toCompile).add(file);
                }
            }
            if (!toCompile.isEmpty()) {
                this.compileFiles(compileContext, module, toCompile, sink, false);
            }
            if (toCompileTests.isEmpty()) continue;
            this.compileFiles(compileContext, module, toCompileTests, sink, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean shouldCompile(VirtualFile file, CompilerConfiguration configuration, PsiManager manager) {
        if (configuration.isResourceFile(file)) {
            return false;
        }
        FileType fileType = file.getFileType();
        if (fileType == GroovyFileType.GROOVY_FILE_TYPE) {
            AccessToken accessToken = ApplicationManager.getApplication().acquireReadActionLock();
            try {
                PsiFile psiFile = manager.findFile(file);
                if (psiFile instanceof GroovyFile && ((GroovyFile)psiFile).isScript()) {
                    GroovyScriptType scriptType = GroovyScriptTypeDetector.getScriptType((GroovyFile)psiFile);
                    boolean bl = scriptType.shouldBeCompiled((GroovyFile)psiFile);
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                accessToken.finish();
            }
        }
        return fileType == StdFileTypes.JAVA;
    }

    protected abstract void compileFiles(CompileContext var1, Module var2, List<VirtualFile> var3, TranslatingCompiler.OutputSink var4, boolean var5);

    public boolean isCompilableFile(VirtualFile file, CompileContext context) {
        boolean result = ((Object)((Object)GroovyFileType.GROOVY_FILE_TYPE)).equals(file.getFileType());
        if (result && LOG.isDebugEnabled()) {
            LOG.debug("compilable file: " + file.getPath());
        }
        return result;
    }
}

