/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyNotifyWhileNotSynchronizedInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Threading issues" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/threading/GroovyNotifyWhileNotSynchronizedInspection", "getGroupDisplayName"));
        }
        return "Threading issues";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("'notify()' or 'notifyAll()' while not synced" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/threading/GroovyNotifyWhileNotSynchronizedInspection", "getDisplayName"));
        }
        return "'notify()' or 'notifyAll()' while not synced";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Call to'#ref' outside of synchronized context #loc";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitMethodCallExpression(GrMethodCallExpression grMethodCallExpression) {
            super.visitMethodCallExpression(grMethodCallExpression);
            GrExpression methodExpression = grMethodCallExpression.getInvokedExpression();
            if (!(methodExpression instanceof GrReferenceExpression)) {
                return;
            }
            GrReferenceExpression reference = (GrReferenceExpression)methodExpression;
            String name = reference.getReferenceName();
            if (!"notify".equals(name) && !"notifyAll".equals(name)) {
                return;
            }
            PsiMethod method = grMethodCallExpression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null || !"java.lang.Object".equals(containingClass.getQualifiedName())) {
                return;
            }
            GrMethod containingMethod = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)grMethodCallExpression, GrMethod.class);
            if (containingMethod != null && containingMethod.hasModifierProperty("synchronized")) {
                return;
            }
            GrStatement parent = (GrStatement)PsiTreeUtil.getParentOfType((PsiElement)grMethodCallExpression, (Class[])new Class[]{GrSynchronizedStatement.class, GrClosableBlock.class});
            if (parent instanceof GrSynchronizedStatement) {
                return;
            }
            this.registerMethodCallError(grMethodCallExpression, new Object[0]);
        }
    }
}

