/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;

public class GroovyFallthroughInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Control Flow" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyFallthroughInspection", "getGroupDisplayName"));
        }
        return "Control Flow";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Fall-through in switch statement" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyFallthroughInspection", "getDisplayName"));
        }
        return "Fall-through in switch statement";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Fall-through in switch statement #loc";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private static final Pattern commentPattern = Pattern.compile("(?i)falls?\\s*thro?u");

        private Visitor() {
        }

        @Override
        public void visitSwitchStatement(GrSwitchStatement switchStatement) {
            super.visitSwitchStatement(switchStatement);
            GrCaseSection[] caseSections = switchStatement.getCaseSections();
            for (int i = 1; i < caseSections.length; ++i) {
                GrCaseSection caseSection = caseSections[i];
                if (Visitor.isCommented(caseSection)) continue;
                GrCaseSection previousCaseSection = caseSections[i - 1];
                GrStatement[] statements = previousCaseSection.getStatements();
                if (statements.length == 0) {
                    this.registerError(caseSection.getFirstChild());
                    continue;
                }
                GrStatement lastStatement = statements[statements.length - 1];
                if (!ControlFlowUtils.statementMayCompleteNormally(lastStatement)) continue;
                this.registerError(caseSection.getFirstChild());
            }
        }

        private static boolean isCommented(GrCaseSection caseClause) {
            PsiElement element = PsiTreeUtil.skipSiblingsBackward((PsiElement)caseClause, (Class[])new Class[]{PsiWhiteSpace.class});
            if (!(element instanceof PsiComment)) {
                return false;
            }
            String commentText = element.getText();
            return commentPattern.matcher(commentText).find();
        }
    }
}

