/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;

public class GroovyBreakInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Control Flow" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyBreakInspection", "getGroupDisplayName"));
        }
        return "Control Flow";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Break statement" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyBreakInspection", "getDisplayName"));
        }
        return "Break statement";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "#ref statement #loc";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitBreakStatement(GrBreakStatement breakStatement) {
            super.visitBreakStatement(breakStatement);
            GrStatement target = breakStatement.findTargetStatement();
            if (target instanceof GrSwitchStatement) {
                return;
            }
            this.registerError(breakStatement);
        }
    }
}

