/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.arithmetic.GrRangeExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrRangeType;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GroovyRangeTypeCheckInspection
extends BaseInspection {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.codeInspection.bugs.GroovyRangeTypeCheckInspection");

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        MyVisitor myVisitor = new MyVisitor();
        if (myVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyRangeTypeCheckInspection", "buildVisitor"));
        }
        return myVisitor;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Probable bugs" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyRangeTypeCheckInspection", "getGroupDisplayName"));
        }
        return "Probable bugs";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = GroovyInspectionBundle.message("incorrect.range.argument", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyRangeTypeCheckInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    protected GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyRangeTypeCheckInspection", "buildFix"));
        }
        GrRangeExpression range = (GrRangeExpression)location;
        PsiType type = range.getType();
        final ArrayList<GroovyFix> fixes = new ArrayList<GroovyFix>(3);
        if (type instanceof GrRangeType) {
            PsiType iterationType = ((GrRangeType)type).getIterationType();
            if (!(iterationType instanceof PsiClassType)) {
                return null;
            }
            final PsiClass psiClass = ((PsiClassType)iterationType).resolve();
            if (!(psiClass instanceof GrTypeDefinition)) {
                return null;
            }
            GroovyResolveResult[] nexts = ResolveUtil.getMethodCandidates(iterationType, "next", (PsiElement)range, new PsiType[0]);
            GroovyResolveResult[] previouses = ResolveUtil.getMethodCandidates(iterationType, "previous", (PsiElement)range, new PsiType[0]);
            GroovyResolveResult[] compareTos = ResolveUtil.getMethodCandidates(iterationType, "compareTo", (PsiElement)range, iterationType);
            if (GroovyRangeTypeCheckInspection.countImplementations(psiClass, nexts) == 0) {
                fixes.add(new AddMethodFix("next", (GrTypeDefinition)psiClass));
            }
            if (GroovyRangeTypeCheckInspection.countImplementations(psiClass, previouses) == 0) {
                fixes.add(new AddMethodFix("previous", (GrTypeDefinition)psiClass));
            }
            if (!InheritanceUtil.isInheritor((PsiType)iterationType, (String)"java.lang.Comparable") || GroovyRangeTypeCheckInspection.countImplementations(psiClass, compareTos) == 0) {
                fixes.add(new AddClassToExtends((GrTypeDefinition)psiClass, "java.lang.Comparable"));
            }
            return new GroovyFix(){

                @Override
                protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
                    for (GroovyFix fix : fixes) {
                        fix.applyFix(project, descriptor);
                    }
                }

                @NotNull
                public String getName() {
                    String string = GroovyInspectionBundle.message("fix.class", psiClass.getName());
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyRangeTypeCheckInspection$1", "getName"));
                    }
                    return string;
                }
            };
        }
        return null;
    }

    private static int countImplementations(PsiClass clazz, GroovyResolveResult[] methods) {
        if (clazz.isInterface()) {
            return methods.length;
        }
        int result = 0;
        for (GroovyResolveResult method : methods) {
            PsiElement el = method.getElement();
            if (el instanceof PsiMethod && !((PsiMethod)el).hasModifierProperty("abstract")) {
                ++result;
                continue;
            }
            if (!(el instanceof PsiField)) continue;
            ++result;
        }
        return result;
    }

    @Override
    protected String buildErrorString(Object ... args) {
        switch (args.length) {
            case 1: {
                return GroovyInspectionBundle.message("type.doesnt.implemnt.comparable", args);
            }
            case 2: {
                return GroovyInspectionBundle.message("type.doesnt.contain.method", args);
            }
        }
        throw new IncorrectOperationException("incorrect args:" + Arrays.toString(args));
    }

    private static String generateTypeText(GrTypeDefinition aClass) {
        StringBuilder returnType = new StringBuilder(aClass.getName());
        PsiTypeParameter[] typeParameters = aClass.getTypeParameters();
        if (typeParameters.length > 0) {
            returnType.append('<');
            for (PsiTypeParameter typeParameter : typeParameters) {
                returnType.append(typeParameter.getName()).append(", ");
            }
            returnType.replace(returnType.length() - 2, returnType.length(), ">");
        }
        return returnType.toString();
    }

    private static class AddClassToExtends
    extends GroovyFix {
        private GrTypeDefinition myPsiClass;
        private String myInterfaceName;

        public AddClassToExtends(GrTypeDefinition psiClass, String interfaceName) {
            this.myPsiClass = psiClass;
            this.myInterfaceName = interfaceName;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiTypeParameter[] typeParameters;
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
            PsiClass comparable = JavaPsiFacade.getInstance((Project)project).findClass("java.lang.Comparable", this.myPsiClass.getResolveScope());
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
            boolean addTypeParam = false;
            if (comparable != null && (typeParameters = comparable.getTypeParameters()).length == 1) {
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
                PsiTypeParameter[] classParams = this.myPsiClass.getTypeParameters();
                PsiSubstitutor innerSubstitutor = PsiSubstitutor.EMPTY;
                for (PsiTypeParameter classParam : classParams) {
                    innerSubstitutor = innerSubstitutor.put(classParam, (PsiType)elementFactory.createType((PsiClass)classParam));
                }
                substitutor = substitutor.put(typeParameters[0], (PsiType)elementFactory.createType((PsiClass)this.myPsiClass, innerSubstitutor));
                addTypeParam = true;
            }
            if (!InheritanceUtil.isInheritor((PsiClass)this.myPsiClass, (String)"java.lang.Comparable")) {
                GroovyPsiElement anchor;
                GrReferenceList list;
                if (this.myPsiClass.isInterface()) {
                    list = this.myPsiClass.getExtendsClause();
                    if (list == null) {
                        list = factory.createExtendsClause();
                        anchor = this.myPsiClass.getImplementsClause();
                        if (anchor == null) {
                            anchor = this.myPsiClass.getBody();
                        }
                        if (anchor == null) {
                            return;
                        }
                        list = (GrReferenceList)this.myPsiClass.addBefore(list, anchor);
                        this.myPsiClass.getNode().addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", anchor.getNode());
                        this.myPsiClass.getNode().addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", list.getNode());
                    }
                } else {
                    list = this.myPsiClass.getImplementsClause();
                    if (list == null) {
                        list = factory.createImplementsClause();
                        anchor = this.myPsiClass.getBody();
                        if (anchor == null) {
                            return;
                        }
                        list = (GrReferenceList)this.myPsiClass.addBefore(list, anchor);
                        this.myPsiClass.getNode().addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", list.getNode());
                        this.myPsiClass.getNode().addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", anchor.getNode());
                    }
                }
                GrCodeReferenceElement _ref = factory.createReferenceElementFromText(this.myInterfaceName + (addTypeParam ? "<" + GroovyRangeTypeCheckInspection.generateTypeText(this.myPsiClass) + ">" : ""));
                GrCodeReferenceElement ref = (GrCodeReferenceElement)list.add(_ref);
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)ref);
            }
            if (comparable != null && !this.myPsiClass.isInterface()) {
                PsiMethod baseMethod = comparable.getMethods()[0];
                OverrideImplementUtil.overrideOrImplement((PsiClass)this.myPsiClass, (PsiMethod)baseMethod);
            }
        }

        @NotNull
        public String getName() {
            String string = GroovyInspectionBundle.message("implement.class", this.myInterfaceName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyRangeTypeCheckInspection$AddClassToExtends", "getName"));
            }
            return string;
        }
    }

    private static class AddMethodFix
    extends GroovyFix {
        private final String myMethodName;
        private final GrTypeDefinition myClass;

        private AddMethodFix(String methodName, GrTypeDefinition aClass) {
            this.myMethodName = methodName;
            this.myClass = aClass;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            if (this.myClass.isInterface()) {
                GrMethod method = GroovyPsiElementFactory.getInstance(project).createMethodFromText("def " + this.myClass.getName() + " " + this.myMethodName + "();");
                this.myClass.add(method);
            } else {
                String templName = "Implemented Method Body.java";
                FileTemplate template = FileTemplateManager.getInstance().getCodeTemplate(templName);
                Properties properties = new Properties();
                String returnType = GroovyRangeTypeCheckInspection.generateTypeText(this.myClass);
                properties.setProperty("RETURN_TYPE", returnType);
                properties.setProperty("DEFAULT_RETURN_VALUE", PsiTypesUtil.getDefaultValueOfType((PsiType)JavaPsiFacade.getElementFactory((Project)project).createType((PsiClass)this.myClass)));
                properties.setProperty("CALL_SUPER", "");
                properties.setProperty("CLASS_NAME", this.myClass.getQualifiedName());
                properties.setProperty("SIMPLE_CLASS_NAME", this.myClass.getName());
                properties.setProperty("METHOD_NAME", this.myMethodName);
                try {
                    String bodyText = StringUtil.replace((String)template.getText(properties), (String)";", (String)"");
                    GrCodeBlock newBody = GroovyPsiElementFactory.getInstance(project).createMethodBodyFromText("\n" + bodyText + "\n");
                    GrMethod method = GroovyPsiElementFactory.getInstance(project).createMethodFromText("", this.myMethodName, returnType, ArrayUtil.EMPTY_STRING_ARRAY, this.myClass);
                    method.setBlock(newBody);
                    this.myClass.add(method);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }

        @NotNull
        public String getName() {
            String string = GroovyInspectionBundle.message("add.method", this.myMethodName, this.myClass.getName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyRangeTypeCheckInspection$AddMethodFix", "getName"));
            }
            return string;
        }
    }

    private static class MyVisitor
    extends BaseInspectionVisitor {
        private MyVisitor() {
        }

        @Override
        public void visitRangeExpression(GrRangeExpression range) {
            super.visitRangeExpression(range);
            PsiType type = range.getType();
            if (!(type instanceof GrRangeType)) {
                return;
            }
            PsiType iterationType = ((GrRangeType)type).getIterationType();
            if (iterationType == null) {
                return;
            }
            GroovyResolveResult[] nexts = ResolveUtil.getMethodCandidates(iterationType, "next", (PsiElement)range, PsiType.EMPTY_ARRAY);
            GroovyResolveResult[] previouses = ResolveUtil.getMethodCandidates(iterationType, "previous", (PsiElement)range, PsiType.EMPTY_ARRAY);
            if (nexts.length == 0) {
                this.registerError((PsiElement)range, iterationType.getPresentableText(), "next()");
            }
            if (previouses.length == 0) {
                this.registerError((PsiElement)range, iterationType.getPresentableText(), "previous()");
            }
            if (!InheritanceUtil.isInheritor((PsiType)iterationType, (String)"java.lang.Comparable")) {
                this.registerError((PsiElement)range, iterationType.getPresentableText());
            }
        }
    }
}

