/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.EquivalenceChecker;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class GroovySillyAssignmentInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Assignment issues" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovySillyAssignmentInspection", "getGroupDisplayName"));
        }
        return "Assignment issues";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Silly assignment" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovySillyAssignmentInspection", "getDisplayName"));
        }
        return "Silly assignment";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Silly assignment #loc";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor = new Visitor();
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovySillyAssignmentInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitAssignmentExpression(@NotNull GrAssignmentExpression assignment) {
            if (assignment == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovySillyAssignmentInspection$Visitor", "visitAssignmentExpression"));
            }
            super.visitAssignmentExpression(assignment);
            IElementType sign = assignment.getOperationTokenType();
            if (!sign.equals(GroovyTokenTypes.mASSIGN)) {
                return;
            }
            GrExpression lhs = assignment.getLValue();
            GrExpression rhs = assignment.getRValue();
            if (rhs == null) {
                return;
            }
            if (!(rhs instanceof GrReferenceExpression) || !(lhs instanceof GrReferenceExpression)) {
                return;
            }
            GrReferenceExpression rhsReference = (GrReferenceExpression)rhs;
            GrReferenceExpression lhsReference = (GrReferenceExpression)lhs;
            GrExpression rhsQualifier = rhsReference.getQualifierExpression();
            GrExpression lhsQualifier = lhsReference.getQualifierExpression();
            if (!(rhsQualifier == null && lhsQualifier == null || EquivalenceChecker.expressionsAreEquivalent(rhsQualifier, lhsQualifier))) {
                return;
            }
            String rhsName = rhsReference.getReferenceName();
            String lhsName = lhsReference.getReferenceName();
            if (rhsName == null || lhsName == null) {
                return;
            }
            if (!rhsName.equals(lhsName)) {
                return;
            }
            PsiElement rhsReferent = rhsReference.resolve();
            PsiElement lhsReferent = lhsReference.resolve();
            if (rhsReferent == null || lhsReferent == null || !rhsReferent.equals(lhsReferent)) {
                return;
            }
            this.registerError(assignment);
        }
    }
}

