/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInsight.hint;

import com.intellij.codeInsight.hint.DeclarationRangeHandler;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GrMethodDeclarationRangeHandler
implements DeclarationRangeHandler<GrMethod> {
    @NotNull
    public TextRange getDeclarationRange(@NotNull GrMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInsight/hint/GrMethodDeclarationRangeHandler", "getDeclarationRange"));
        }
        TextRange textRange = method.getModifierList().getTextRange();
        int startOffset = textRange != null ? textRange.getStartOffset() : method.getTextOffset();
        int endOffset = method.getThrowsList().getTextRange().getEndOffset();
        TextRange textRange2 = new TextRange(startOffset, endOffset);
        if (textRange2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInsight/hint/GrMethodDeclarationRangeHandler", "getDeclarationRange"));
        }
        return textRange2;
    }
}

