/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.ant;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.ChunkCustomCompilerExtension;
import com.intellij.compiler.ant.CompositeGenerator;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.ModuleChunk;
import com.intellij.compiler.ant.Tag;
import com.intellij.compiler.ant.taskdefs.PatternSetRef;
import com.intellij.compiler.ant.taskdefs.Property;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.GroovyFileTypeLoader;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public class GroovyAntCustomCompilerProvider
extends ChunkCustomCompilerExtension {
    @NonNls
    private static final String GROOVYC_TASK_SDK_PROPERTY = "grooovyc.task.sdk";

    public void generateCustomCompile(Project project, ModuleChunk chunk, GenerationOptions genOptions, boolean compileTests, CompositeGenerator generator, Tag compilerArgs, Tag bootClassPathTag, Tag classpathTag, PatternSetRef compilerExcludes, Tag srcTag, String outputPathRef) {
        Tag groovyc = new Tag("groovyc", new Pair[]{Pair.create((Object)"destdir", (Object)outputPathRef), Pair.create((Object)"fork", (Object)"yes")});
        groovyc.add((Generator)srcTag);
        groovyc.add((Generator)classpathTag);
        groovyc.add((Generator)compilerExcludes);
        Tag javac = new Tag("javac", new Pair[]{Pair.create((Object)"debug", (Object)BuildProperties.propertyRef((String)"compiler.debug"))});
        javac.add((Generator)compilerArgs);
        groovyc.add((Generator)javac);
        generator.add((Generator)groovyc);
    }

    public void generateCustomCompilerTaskRegistration(Project project, GenerationOptions genOptions, CompositeGenerator generator) {
        GroovyConfigUtils utils = GroovyConfigUtils.getInstance();
        Library[] libraries = utils.getAllUsedSDKLibraries(project);
        if (libraries.length == 0) {
            return;
        }
        Collection<String> versions = utils.getSDKVersions(libraries);
        String maxVersion = versions.isEmpty() ? null : Collections.max(versions);
        Library sdkLib = null;
        for (Library lib : libraries) {
            if (maxVersion != null && !maxVersion.equals(utils.getSDKVersion(LibrariesUtil.getGroovyLibraryHome(lib)))) continue;
            sdkLib = lib;
        }
        assert (sdkLib != null);
        String groovySdkPathRef = BuildProperties.getLibraryPathId((String)sdkLib.getName());
        generator.add((Generator)new Property(GROOVYC_TASK_SDK_PROPERTY, groovySdkPathRef));
        Tag taskdef = new Tag("taskdef", new Pair[]{Pair.create((Object)"name", (Object)"groovyc"), Pair.create((Object)"classname", (Object)"org.codehaus.groovy.ant.Groovyc"), Pair.create((Object)"classpathref", (Object)"${grooovyc.task.sdk}")});
        generator.add((Generator)taskdef);
    }

    public boolean hasCustomCompile(ModuleChunk chunk) {
        for (Module m : chunk.getModules()) {
            if (!LibrariesUtil.hasGroovySdk(m)) continue;
            final Set<String> scriptExtensions = GroovyFileTypeLoader.getCustomGroovyScriptExtensions();
            ContentIterator groovyFileSearcher = new ContentIterator(){

                public boolean processFile(VirtualFile fileOrDir) {
                    ProgressManager.checkCanceled();
                    return !GroovyAntCustomCompilerProvider.isCompilableGroovyFile(fileOrDir, scriptExtensions);
                }
            };
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)m);
            ModuleFileIndex fileIndex = rootManager.getFileIndex();
            for (VirtualFile file : rootManager.getSourceRoots(JavaModuleSourceRootTypes.SOURCES)) {
                if (fileIndex.iterateContentUnderDirectory(file, groovyFileSearcher)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isCompilableGroovyFile(VirtualFile file, Set<String> scriptExtensions) {
        return !file.isDirectory() && GroovyFileType.GROOVY_FILE_TYPE == file.getFileType() && !scriptExtensions.contains(file.getExtension());
    }
}

