/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ParamInfo;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui.DynamicElementSettings;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrReferenceResolveUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class QuickfixUtil {
    @Nullable
    public static PsiClass findTargetClass(GrReferenceExpression refExpr, boolean compileStatic) {
        if (refExpr.getQualifier() == null) {
            return PsiUtil.getContextClass(refExpr);
        }
        PsiType type = GrReferenceResolveUtil.getQualifierType(refExpr);
        if (type == null && compileStatic) {
            return GroovyPsiManager.getInstance(refExpr.getProject()).findClassWithCache("java.lang.Object", refExpr.getResolveScope());
        }
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        return ((PsiClassType)type).resolve();
    }

    public static boolean isStaticCall(GrReferenceExpression refExpr) {
        GrExpression qualifierExpression = refExpr.getQualifierExpression();
        if (!(qualifierExpression instanceof GrReferenceExpression)) {
            return false;
        }
        GrReferenceExpression referenceExpression = (GrReferenceExpression)qualifierExpression;
        GroovyPsiElement resolvedElement = ResolveUtil.resolveProperty(referenceExpression, referenceExpression.getReferenceName());
        if (resolvedElement == null) {
            return false;
        }
        return resolvedElement instanceof PsiClass;
    }

    public static boolean ensureFileWritable(Project project, PsiFile file) {
        VirtualFile virtualFile = file.getVirtualFile();
        ReadonlyStatusHandler readonlyStatusHandler = ReadonlyStatusHandler.getInstance((Project)project);
        ReadonlyStatusHandler.OperationStatus operationStatus = readonlyStatusHandler.ensureFilesWritable(new VirtualFile[]{virtualFile});
        return !operationStatus.hasReadonlyFiles();
    }

    public static Editor positionCursor(@NotNull Project project, @NotNull PsiFile targetFile, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/annotator/intentions/QuickfixUtil", "positionCursor"));
        }
        if (targetFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/annotator/intentions/QuickfixUtil", "positionCursor"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/annotator/intentions/QuickfixUtil", "positionCursor"));
        }
        TextRange range = element.getTextRange();
        int textOffset = range.getStartOffset();
        VirtualFile vFile = targetFile.getVirtualFile();
        assert (vFile != null);
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, vFile, textOffset);
        return FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
    }

    public static String[] getMethodArgumentsNames(Project project, PsiType[] types) {
        LinkedHashSet<String> uniqNames = new LinkedHashSet<String>();
        THashSet nonUniqNames = new THashSet();
        for (PsiType type : types) {
            SuggestedNameInfo nameInfo = JavaCodeStyleManager.getInstance((Project)project).suggestVariableName(VariableKind.PARAMETER, null, null, type);
            String name = nameInfo.names[0];
            if (uniqNames.contains(name)) {
                int i = 2;
                while (uniqNames.contains(name + i)) {
                    ++i;
                }
                uniqNames.add(name + i);
                nonUniqNames.add(name);
                continue;
            }
            uniqNames.add(name);
        }
        String[] result = new String[uniqNames.size()];
        int i = 0;
        for (String name : uniqNames) {
            result[i] = nonUniqNames.contains(name) ? name + 1 : name;
            ++i;
        }
        return result;
    }

    public static List<ParamInfo> swapArgumentsAndTypes(String[] names, PsiType[] types) {
        ArrayList<ParamInfo> result = new ArrayList<ParamInfo>();
        if (names.length != types.length) {
            return Collections.emptyList();
        }
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            PsiType type = types[i];
            result.add(new ParamInfo(name, type.getCanonicalText()));
        }
        return result;
    }

    public static boolean isCall(GrReferenceExpression referenceExpression) {
        return referenceExpression.getParent() instanceof GrCall;
    }

    public static String[] getArgumentsTypes(List<ParamInfo> listOfPairs) {
        ArrayList<String> result = new ArrayList<String>();
        if (listOfPairs == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        for (ParamInfo listOfPair : listOfPairs) {
            String type = PsiTypesUtil.unboxIfPossible((String)listOfPair.type);
            result.add(type);
        }
        return ArrayUtil.toStringArray(result);
    }

    public static String[] getArgumentsNames(List<ParamInfo> listOfPairs) {
        ArrayList<String> result = new ArrayList<String>();
        for (ParamInfo listOfPair : listOfPairs) {
            String name = listOfPair.name;
            result.add(name);
        }
        return ArrayUtil.toStringArray(result);
    }

    public static String shortenType(String typeText) {
        if (typeText == null) {
            return "";
        }
        int i = typeText.lastIndexOf(".");
        if (i != -1) {
            return typeText.substring(i + 1);
        }
        return typeText;
    }

    public static DynamicElementSettings createSettings(GrReferenceExpression referenceExpression) {
        DynamicElementSettings settings = new DynamicElementSettings();
        PsiClass containingClass = QuickfixUtil.findTargetClass(referenceExpression, false);
        assert (containingClass != null);
        String className = containingClass.getQualifiedName();
        String string = className = className == null ? containingClass.getContainingFile().getName() : className;
        if (QuickfixUtil.isStaticCall(referenceExpression)) {
            settings.setStatic(true);
        }
        settings.setContainingClassName(className);
        settings.setName(referenceExpression.getReferenceName());
        if (QuickfixUtil.isCall(referenceExpression)) {
            ArrayList<PsiType> unboxedTypes = new ArrayList<PsiType>();
            for (PsiType type : PsiUtil.getArgumentTypes(referenceExpression, false)) {
                unboxedTypes.add(TypesUtil.unboxPrimitiveTypeWrapperAndEraseGenerics(type));
            }
            PsiType[] types = unboxedTypes.toArray(PsiType.createArray((int)unboxedTypes.size()));
            String[] names = QuickfixUtil.getMethodArgumentsNames(referenceExpression.getProject(), types);
            List<ParamInfo> infos = QuickfixUtil.swapArgumentsAndTypes(names, types);
            settings.setMethod(true);
            settings.setParams(infos);
        } else {
            settings.setMethod(false);
        }
        return settings;
    }

    public static DynamicElementSettings createSettings(GrArgumentLabel label, PsiClass targetClass) {
        DynamicElementSettings settings = new DynamicElementSettings();
        assert (targetClass != null);
        String className = targetClass.getQualifiedName();
        className = className == null ? targetClass.getContainingFile().getName() : className;
        settings.setContainingClassName(className);
        settings.setName(label.getName());
        return settings;
    }
}

