/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.CustomAnnotationChecker;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class TypeCheckedAnnotationChecker
extends CustomAnnotationChecker {
    @Override
    public boolean checkArgumentList(@NotNull AnnotationHolder holder, @NotNull GrAnnotation annotation) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/annotator/TypeCheckedAnnotationChecker", "checkArgumentList"));
        }
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/annotator/TypeCheckedAnnotationChecker", "checkArgumentList"));
        }
        GrCodeReferenceElement classReference = annotation.getClassReference();
        PsiElement resolved = classReference.resolve();
        if (!(resolved instanceof PsiClass) || !"groovy.transform.TypeChecked".equals(((PsiClass)resolved).getQualifiedName())) {
            return false;
        }
        String sdkVersion = GroovyConfigUtils.getInstance().getSDKVersion(annotation);
        if (!"2.1".equals(sdkVersion) && !"2.1.0".equals(sdkVersion)) {
            return false;
        }
        GrAnnotationNameValuePair[] attributes = annotation.getParameterList().getAttributes();
        HashMap errorMap = ContainerUtil.newHashMap();
        CustomAnnotationChecker.checkAnnotationArguments(errorMap, (PsiClass)resolved, classReference, attributes, false);
        TypeCheckedAnnotationChecker.highlightErrors(holder, errorMap);
        return true;
    }
}

