/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.annotator.GrHighlightUtil;
import org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess.GrUnresolvedAccessInspection;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;

public class GrReferenceHighlighter
extends TextEditorHighlightingPass {
    @NotNull
    private final GroovyFileBase myFile;
    private List<HighlightInfo> myInfos;
    private final GroovyRecursiveElementVisitor myDeclarationHighlighter;
    private final GroovyRecursiveElementVisitor myResolveHighlighter;

    public GrReferenceHighlighter(@Nullable Document document, @NotNull GroovyFileBase file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/annotator/GrReferenceHighlighter", "<init>"));
        }
        super(file.getProject(), document);
        this.myInfos = null;
        this.myDeclarationHighlighter = new GroovyRecursiveElementVisitor(){

            @Override
            public void visitReferenceExpression(GrReferenceExpression referenceExpression) {
                super.visitReferenceExpression(referenceExpression);
                this.visit(referenceExpression);
            }

            @Override
            public void visitCodeReferenceElement(GrCodeReferenceElement refElement) {
                super.visitCodeReferenceElement(refElement);
                this.visit(refElement);
            }

            @Override
            public void visitVariable(GrVariable variable) {
                TextAttributesKey attribute;
                super.visitVariable(variable);
                if ((GroovyRefactoringUtil.isLocalVariable(variable) || variable instanceof GrParameter) && (attribute = GrHighlightUtil.getDeclarationHighlightingAttribute(variable, null)) != null) {
                    PsiElement nameElement = variable.getNameIdentifierGroovy();
                    this.addInfo(attribute, nameElement);
                }
            }

            private void visit(GrReferenceElement element) {
                ProgressManager.checkCanceled();
                PsiElement resolved = element.resolve();
                TextAttributesKey attribute = GrHighlightUtil.getDeclarationHighlightingAttribute(resolved, element);
                if (attribute != null) {
                    PsiElement refNameElement = GrHighlightUtil.getElementToHighlight(element);
                    this.addInfo(attribute, refNameElement);
                }
            }

            private void addInfo(TextAttributesKey attribute, PsiElement nameElement) {
                assert (GrReferenceHighlighter.this.myInfos != null);
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.INFORMATION).range(nameElement).needsUpdateOnTyping(false).textAttributes(attribute).create();
                if (info != null) {
                    GrReferenceHighlighter.this.myInfos.add(info);
                }
            }
        };
        this.myResolveHighlighter = new GroovyRecursiveElementVisitor(){

            @Override
            public void visitReferenceExpression(GrReferenceExpression referenceExpression) {
                List<HighlightInfo> infos;
                int size = GrReferenceHighlighter.this.myInfos.size();
                super.visitReferenceExpression(referenceExpression);
                if (size == GrReferenceHighlighter.this.myInfos.size() && (infos = GrUnresolvedAccessInspection.checkReferenceExpression(referenceExpression)) != null) {
                    assert (GrReferenceHighlighter.this.myInfos != null);
                    GrReferenceHighlighter.this.myInfos.addAll(infos);
                }
            }

            @Override
            public void visitCodeReferenceElement(GrCodeReferenceElement refElement) {
                HighlightInfo info;
                int size = GrReferenceHighlighter.this.myInfos.size();
                super.visitCodeReferenceElement(refElement);
                if (size == GrReferenceHighlighter.this.myInfos.size() && (info = GrUnresolvedAccessInspection.checkCodeReferenceElement(refElement)) != null) {
                    assert (GrReferenceHighlighter.this.myInfos != null);
                    GrReferenceHighlighter.this.myInfos.add(info);
                }
            }
        };
        this.myFile = file;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/annotator/GrReferenceHighlighter", "doCollectInformation"));
        }
        this.myInfos = new ArrayList<HighlightInfo>();
        this.myFile.accept(this.myDeclarationHighlighter);
        this.myFile.accept(this.myResolveHighlighter);
    }

    public void doApplyInformationToEditor() {
        if (this.myInfos == null) {
            return;
        }
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.myFile.getTextLength(), this.myInfos, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
    }
}

