/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.CustomAnnotationChecker;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrAnnotationCollector;

public class GrAliasAnnotationChecker
extends CustomAnnotationChecker {
    @Override
    public boolean checkApplicability(@NotNull AnnotationHolder holder, @NotNull GrAnnotation annotation) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/annotator/GrAliasAnnotationChecker", "checkApplicability"));
        }
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/annotator/GrAliasAnnotationChecker", "checkApplicability"));
        }
        PsiAnnotation annotationCollector = GrAnnotationCollector.findAnnotationCollector(annotation);
        if (annotationCollector == null) {
            return false;
        }
        GrCodeReferenceElement ref = annotation.getClassReference();
        ArrayList aliasedAnnotations = ContainerUtil.newArrayList();
        GrAnnotationCollector.collectAnnotations(aliasedAnnotations, annotation, annotationCollector);
        for (GrAnnotation anno : aliasedAnnotations) {
            String description;
            if ("groovy.transform.AnnotationCollector".equals(anno.getQualifiedName()) || (description = CustomAnnotationChecker.isAnnotationApplicable(anno, annotation.getParent())) == null) continue;
            holder.createErrorAnnotation((PsiElement)ref, description);
        }
        return true;
    }

    @Override
    public boolean checkArgumentList(@NotNull AnnotationHolder holder, @NotNull GrAnnotation annotation) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/annotator/GrAliasAnnotationChecker", "checkArgumentList"));
        }
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/annotator/GrAliasAnnotationChecker", "checkArgumentList"));
        }
        PsiAnnotation annotationCollector = GrAnnotationCollector.findAnnotationCollector(annotation);
        if (annotationCollector == null) {
            return false;
        }
        ArrayList annotations = ContainerUtil.newArrayList();
        Set<String> usedAttributes = GrAnnotationCollector.collectAnnotations(annotations, annotation, annotationCollector);
        GrCodeReferenceElement ref = annotation.getClassReference();
        HashMap map = ContainerUtil.newHashMap();
        for (GrAnnotation grAnnotation : annotations) {
            PsiClass clazz = (PsiClass)grAnnotation.getClassReference().resolve();
            assert (clazz != null);
            GrAliasAnnotationChecker.checkAnnotationArguments(map, clazz, ref, grAnnotation.getParameterList().getAttributes(), true);
        }
        for (Map.Entry entry : map.entrySet()) {
            PsiElement key = (PsiElement)entry.getKey();
            String value = (String)entry.getValue();
            if (PsiTreeUtil.isAncestor((PsiElement)annotation, (PsiElement)key, (boolean)true)) {
                holder.createErrorAnnotation(key, value);
                continue;
            }
            holder.createErrorAnnotation((PsiElement)ref, value);
        }
        GrAnnotationNameValuePair[] attributes = annotation.getParameterList().getAttributes();
        String string = annotation.getQualifiedName();
        if (attributes.length == 1 && attributes[0].getNameIdentifierGroovy() == null && !usedAttributes.contains("value")) {
            holder.createErrorAnnotation((PsiElement)attributes[0], GroovyBundle.message("at.interface.0.does.not.contain.attribute", string, "value"));
        }
        for (GrAnnotationNameValuePair pair : attributes) {
            PsiElement nameIdentifier = pair.getNameIdentifierGroovy();
            if (nameIdentifier == null || usedAttributes.contains(pair.getName())) continue;
            holder.createErrorAnnotation(nameIdentifier, GroovyBundle.message("at.interface.0.does.not.contain.attribute", string, pair.getName()));
        }
        return true;
    }
}

