/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.CustomAnnotationChecker;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;

public class AnnotationCollectorChecker
extends CustomAnnotationChecker {
    @Override
    public boolean checkApplicability(@NotNull AnnotationHolder holder, @NotNull GrAnnotation annotation) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/annotator/AnnotationCollectorChecker", "checkApplicability"));
        }
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/annotator/AnnotationCollectorChecker", "checkApplicability"));
        }
        return AnnotationCollectorChecker.isInAliasDeclaration(annotation);
    }

    @Override
    public boolean checkArgumentList(@NotNull AnnotationHolder holder, @NotNull GrAnnotation annotation) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/annotator/AnnotationCollectorChecker", "checkArgumentList"));
        }
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/annotator/AnnotationCollectorChecker", "checkArgumentList"));
        }
        if (!AnnotationCollectorChecker.isInAliasDeclaration(annotation)) {
            return false;
        }
        HashMap errors = ContainerUtil.newHashMap();
        PsiClass clazz = (PsiClass)annotation.getClassReference().resolve();
        if (clazz == null) {
            return true;
        }
        GrAnnotationNameValuePair[] attributes = annotation.getParameterList().getAttributes();
        CustomAnnotationChecker.checkAnnotationArguments(errors, clazz, annotation.getClassReference(), attributes, false);
        AnnotationCollectorChecker.highlightErrors(holder, errors);
        return true;
    }

    private static boolean isInAliasDeclaration(GrAnnotation annotation) {
        GrAnnotation collector;
        PsiElement parent = annotation.getParent();
        return parent instanceof GrModifierList && (collector = (GrAnnotation)ContainerUtil.find((Object[])((GrModifierList)parent).getRawAnnotations(), (Condition)new Condition<GrAnnotation>(){

            public boolean value(GrAnnotation annotation) {
                return "groovy.transform.AnnotationCollector".equals(annotation.getQualifiedName());
            }
        })) != null;
    }
}

