/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.actions;

import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.actions.JavaCreateTemplateInPackageAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import icons.JetgroovyIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.actions.GroovyTemplatesFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public class NewScriptAction
extends JavaCreateTemplateInPackageAction<GroovyFile> {
    public NewScriptAction() {
        super(GroovyBundle.message("newscript.menu.action.text", new Object[0]), GroovyBundle.message("newscript.menu.action.description", new Object[0]), JetgroovyIcons.Groovy.Groovy_16x16, false);
    }

    protected void buildDialog(Project project, PsiDirectory directory, CreateFileFromTemplateDialog.Builder builder) {
        builder.setTitle(GroovyBundle.message("newscript.dlg.prompt", new Object[0])).addKind("Groovy script", JetgroovyIcons.Groovy.Groovy_16x16, "GroovyScript.groovy").addKind("GroovyDSL script", JetgroovyIcons.Groovy.Groovy_16x16, "GroovyDslScript.gdsl");
    }

    protected boolean isAvailable(DataContext dataContext) {
        return super.isAvailable(dataContext) && LibrariesUtil.hasGroovySdk((Module)LangDataKeys.MODULE.getData(dataContext));
    }

    protected String getActionName(PsiDirectory directory, String newName, String templateName) {
        return GroovyBundle.message("newscript.menu.action.text", new Object[0]);
    }

    protected PsiElement getNavigationElement(@NotNull GroovyFile createdFile) {
        if (createdFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/actions/NewScriptAction", "getNavigationElement"));
        }
        return createdFile.getLastChild();
    }

    @NotNull
    protected GroovyFile doCreate(PsiDirectory directory, String newName, String templateName) throws IncorrectOperationException {
        String fileName = newName + "." + NewScriptAction.extractExtension(templateName);
        PsiFile file = GroovyTemplatesFactory.createFromTemplate(directory, newName, fileName, templateName, true, new String[0]);
        if (file instanceof GroovyFile) {
            GroovyFile groovyFile = (GroovyFile)file;
            if (groovyFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/actions/NewScriptAction", "doCreate"));
            }
            return groovyFile;
        }
        String description = file.getFileType().getDescription();
        throw new IncorrectOperationException(GroovyBundle.message("groovy.file.extension.is.not.mapped.to.groovy.file.type", description));
    }

    private static String extractExtension(String templateName) {
        if ("GroovyDslScript.gdsl".equals(templateName)) {
            return "gdsl";
        }
        return "groovy";
    }
}

