/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.actions;

import com.intellij.CommonBundle;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.util.GroovyUtils;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public abstract class NewGroovyActionBase
extends CreateElementActionBase {
    @NonNls
    public static final String GROOVY_EXTENSION = ".groovy";

    public NewGroovyActionBase(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    @NotNull
    protected final PsiElement[] invokeDialog(Project project, PsiDirectory directory) {
        CreateElementActionBase.MyInputValidator validator = new CreateElementActionBase.MyInputValidator((CreateElementActionBase)this, project, directory);
        Messages.showInputDialog((Project)project, (String)this.getDialogPrompt(), (String)this.getDialogTitle(), (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)validator);
        PsiElement[] psiElementArray = validator.getCreatedElements();
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/actions/NewGroovyActionBase", "invokeDialog"));
        }
        return psiElementArray;
    }

    protected abstract String getDialogPrompt();

    protected abstract String getDialogTitle();

    protected boolean isAvailable(DataContext dataContext) {
        if (!super.isAvailable(dataContext)) {
            return false;
        }
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        return GroovyUtils.isSuitableModule(module) && LibrariesUtil.hasGroovySdk(module);
    }

    @NotNull
    protected PsiElement[] create(String newName, PsiDirectory directory) throws Exception {
        PsiElement[] psiElementArray = this.doCreate(newName, directory);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/actions/NewGroovyActionBase", "create"));
        }
        return psiElementArray;
    }

    @NotNull
    protected abstract PsiElement[] doCreate(String var1, PsiDirectory var2) throws Exception;

    protected String getErrorTitle() {
        return CommonBundle.getErrorTitle();
    }
}

